/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.monitoring.jmx;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ControlledWorkerScheduler;
import org.eclipse.rdf4j.federated.monitoring.jmx.FederationStatusMBean;
import org.eclipse.rdf4j.query.BindingSet;

public class FederationStatus
implements FederationStatusMBean {
    private final FederationContext federationContext;

    public FederationStatus(FederationContext federationContext) {
        this.federationContext = federationContext;
    }

    @Override
    public List<String> getFederationMembersDescription() {
        List<Endpoint> members = this.federationContext.getFederation().getMembers();
        ArrayList<String> res = new ArrayList<String>();
        for (Endpoint e : members) {
            res.add(e.toString());
        }
        return res;
    }

    @Override
    public int getIdleJoinWorkerThreads() {
        ControlledWorkerScheduler<BindingSet> scheduler = this.federationContext.getManager().getJoinScheduler();
        return scheduler.getNumberOfIdleWorkers();
    }

    @Override
    public int getTotalJoinWorkerThreads() {
        ControlledWorkerScheduler<BindingSet> scheduler = this.federationContext.getManager().getJoinScheduler();
        return scheduler.getTotalNumberOfWorkers();
    }

    @Override
    public int getIdleUnionWorkerThreads() {
        ControlledWorkerScheduler<BindingSet> scheduler = this.federationContext.getManager().getUnionScheduler();
        return scheduler.getNumberOfIdleWorkers();
    }

    @Override
    public int getTotalUnionWorkerThreads() {
        ControlledWorkerScheduler<BindingSet> scheduler = this.federationContext.getManager().getUnionScheduler();
        return scheduler.getTotalNumberOfWorkers();
    }

    @Override
    public int getNumberOfScheduledJoinTasks() {
        ControlledWorkerScheduler<BindingSet> scheduler = this.federationContext.getManager().getJoinScheduler();
        return scheduler.getNumberOfTasks();
    }

    @Override
    public int getNumberOfScheduledUnionTasks() {
        ControlledWorkerScheduler<BindingSet> scheduler = this.federationContext.getManager().getUnionScheduler();
        return scheduler.getNumberOfTasks();
    }
}

