/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.monitoring;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.federated.monitoring.Monitoring;
import org.eclipse.rdf4j.federated.monitoring.MonitoringImpl;
import org.eclipse.rdf4j.federated.monitoring.MonitoringService;
import org.eclipse.rdf4j.federated.monitoring.jmx.FederationStatus;

public class MonitoringUtil {
    private static boolean JMX_initialized = false;

    public static void printMonitoringInformation(FederationContext federationContext) {
        MonitoringService ms = MonitoringUtil.getMonitoringService(federationContext);
        System.out.println("### Request monitoring: ");
        for (MonitoringImpl.MonitoringInformation m : ms.getAllMonitoringInformation()) {
            System.out.println("\t" + m.toString());
        }
    }

    private static MonitoringService getMonitoringService(FederationContext federationContext) throws FedXRuntimeException {
        Monitoring m = federationContext.getMonitoringService();
        if (m instanceof MonitoringService) {
            return (MonitoringService)m;
        }
        throw new FedXRuntimeException("Monitoring is currently disabled for this system.");
    }

    public static void initializeJMXMonitoring(FederationContext federationContext) throws Exception {
        if (JMX_initialized) {
            return;
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName monitoring = new ObjectName("org.eclipse.rdf4j.federated:type=FederationStatus");
        mbs.registerMBean(new FederationStatus(federationContext), monitoring);
        JMX_initialized = true;
    }
}

