/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.union;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutor;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTaskBase;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public class ParallelPreparedAlgebraUnionTask
extends ParallelTaskBase<BindingSet> {
    protected final Endpoint endpoint;
    protected final TupleExpr preparedQuery;
    protected final BindingSet bindings;
    protected final ParallelExecutor<BindingSet> unionControl;
    protected final FilterValueExpr filterExpr;

    public ParallelPreparedAlgebraUnionTask(ParallelExecutor<BindingSet> unionControl, TupleExpr preparedQuery, Endpoint endpoint, BindingSet bindings, FilterValueExpr filterExpr) {
        this.endpoint = endpoint;
        this.preparedQuery = preparedQuery;
        this.bindings = bindings;
        this.unionControl = unionControl;
        this.filterExpr = filterExpr;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> performTask() throws Exception {
        TripleSource tripleSource = this.endpoint.getTripleSource();
        return tripleSource.getStatements(this.preparedQuery, this.bindings, this.filterExpr);
    }

    @Override
    public ParallelExecutor<BindingSet> getControl() {
        return this.unionControl;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " @" + this.endpoint.getId() + ": " + this.preparedQuery.toString();
    }
}

