/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.concurrent;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.impl.QueueCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedXQueueCursor<T>
extends QueueCursor<CloseableIteration<T, QueryEvaluationException>> {
    private static final Logger log = LoggerFactory.getLogger(FedXQueueCursor.class);
    private final BlockingQueue<CloseableIteration<T, QueryEvaluationException>> queueRef;

    public static <T> FedXQueueCursor<T> create(int capacity) {
        ArrayBlockingQueue<CloseableIteration<T, QueryEvaluationException>> queue = new ArrayBlockingQueue<CloseableIteration<T, QueryEvaluationException>>(capacity, false);
        return new FedXQueueCursor<T>(queue);
    }

    private FedXQueueCursor(BlockingQueue<CloseableIteration<T, QueryEvaluationException>> queue) {
        super(queue);
        this.queueRef = queue;
    }

    protected QueryEvaluationException convert(Exception e) {
        if (e instanceof QueryEvaluationException) {
            return (QueryEvaluationException)((Object)e);
        }
        return super.convert(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleClose() throws QueryEvaluationException {
        try {
            Object take = this.queueRef.poll();
            while (take != null) {
                if (take instanceof CloseableIteration) {
                    CloseableIteration closable = (CloseableIteration)take;
                    try {
                        log.trace("Attempting to close non consumed inner iteration.");
                        closable.close();
                    }
                    catch (Throwable t) {
                        log.trace("Failed to close inner iteration: ", t);
                    }
                }
                take = this.queueRef.poll();
            }
            this.done();
        }
        finally {
            super.handleClose();
        }
    }
}

