/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.ExceptionConvertingIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.algebra.ExclusiveGroup;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.endpoint.SparqlEndpointConfiguration;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.TripleSourceBase;
import org.eclipse.rdf4j.federated.evaluation.iterator.ConsumingIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.FilteringInsertBindingsIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.FilteringIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.InsertBindingsIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;

public class SparqlTripleSource
extends TripleSourceBase
implements TripleSource {
    private boolean useASKQueries = true;

    SparqlTripleSource(Endpoint endpoint, FederationContext federationContext) {
        super(federationContext, endpoint);
        if (endpoint.getEndpointConfiguration() instanceof SparqlEndpointConfiguration) {
            SparqlEndpointConfiguration c = (SparqlEndpointConfiguration)endpoint.getEndpointConfiguration();
            this.useASKQueries = c.supportsASKQueries();
        }
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> getStatements(String preparedQuery, BindingSet bindings, FilterValueExpr filterExpr) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        return this.withConnection((conn, resultHolder) -> {
            TupleQuery query = conn.prepareTupleQuery(QueryLanguage.SPARQL, preparedQuery, null);
            this.applyMaxExecutionTimeUpperBound((Operation)query);
            this.disableInference((Query)query);
            this.monitorRemoteRequest();
            Object res = query.evaluate();
            resultHolder.set(res);
            if (filterExpr != null) {
                res = bindings.size() > 0 ? new FilteringInsertBindingsIteration(filterExpr, bindings, (CloseableIteration<BindingSet, QueryEvaluationException>)res, this.strategy) : new FilteringIteration(filterExpr, (CloseableIteration<BindingSet, QueryEvaluationException>)res, this.strategy);
                if (!res.hasNext()) {
                    Iterations.closeCloseable((Iteration)res);
                    conn.close();
                    resultHolder.set(new EmptyIteration());
                    return;
                }
            } else if (bindings.size() > 0) {
                res = new InsertBindingsIteration((CloseableIteration<BindingSet, QueryEvaluationException>)res, bindings);
            }
            resultHolder.set(new ConsumingIteration((CloseableIteration<BindingSet, QueryEvaluationException>)res));
        });
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> getStatements(StatementPattern stmt, BindingSet bindings, FilterValueExpr filterExpr) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        throw new RuntimeException("NOT YET IMPLEMENTED.");
    }

    @Override
    public boolean hasStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException {
        if (!this.useASKQueries) {
            StatementPattern st = new StatementPattern(new Var("s", (Value)subj), new Var("p", (Value)pred), new Var("o", obj));
            try {
                return this.hasStatements(st, EmptyBindingSet.getInstance());
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return super.hasStatements(subj, pred, obj, contexts);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean hasStatements(StatementPattern stmt, BindingSet bindings) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean hasStatements(ExclusiveGroup group, BindingSet bindings) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean usePreparedQuery() {
        return true;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> getStatements(TupleExpr preparedQuery, BindingSet bindings, FilterValueExpr filterExpr) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        throw new RuntimeException("NOT YET IMPLEMENTED.");
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        return this.withConnection((conn, resultHolder) -> {
            this.monitorRemoteRequest();
            RepositoryResult repoResult = conn.getStatements(subj, pred, obj, true, new Resource[0]);
            resultHolder.set(new ExceptionConvertingIteration<Statement, QueryEvaluationException>((Iteration)repoResult){

                protected QueryEvaluationException convert(Exception ex) {
                    if (ex instanceof QueryEvaluationException) {
                        return (QueryEvaluationException)((Object)ex);
                    }
                    return new QueryEvaluationException((Throwable)ex);
                }
            });
        });
    }

    public String toString() {
        return "Sparql Triple Source: Endpoint - " + this.endpoint.getId();
    }
}

