/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.algebra.FilterTuple;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.evaluation.SparqlFederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.iterator.BoundJoinVALUESConversionIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.FilteringIteration;
import org.eclipse.rdf4j.federated.exception.ExceptionUtil;
import org.eclipse.rdf4j.federated.util.QueryStringUtil;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;

public class SparqlFederationEvalStrategyWithValues
extends SparqlFederationEvalStrategy {
    public SparqlFederationEvalStrategyWithValues(FederationContext federationContext) {
        super(federationContext);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluateBoundJoinStatementPattern(StatementTupleExpr stmt, List<BindingSet> bindings) throws QueryEvaluationException {
        if (bindings.size() == 1) {
            return this.evaluate(stmt, bindings.get(0));
        }
        FilterValueExpr filterExpr = null;
        if (stmt instanceof FilterTuple) {
            filterExpr = ((FilterTuple)((Object)stmt)).getFilterExpr();
        }
        AtomicBoolean isEvaluated = new AtomicBoolean(false);
        String preparedQuery = QueryStringUtil.selectQueryStringBoundJoinVALUES((StatementPattern)stmt, bindings, filterExpr, isEvaluated);
        Object result = null;
        try {
            result = this.evaluateAtStatementSources(preparedQuery, stmt.getStatementSources(), stmt.getQueryInfo());
            if (filterExpr != null && !isEvaluated.get()) {
                result = new BoundJoinVALUESConversionIteration((CloseableIteration<BindingSet, QueryEvaluationException>)result, bindings);
                if (!(result = new FilteringIteration(filterExpr, (CloseableIteration<BindingSet, QueryEvaluationException>)result, this)).hasNext()) {
                    return new EmptyIteration();
                }
            } else {
                result = new BoundJoinVALUESConversionIteration((CloseableIteration<BindingSet, QueryEvaluationException>)result, bindings);
            }
            return result;
        }
        catch (Throwable t) {
            Iterations.closeCloseable(result);
            throw ExceptionUtil.toQueryEvaluationException(t);
        }
    }
}

