/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.ExceptionConvertingIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.algebra.PrecompiledQueryNode;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.TripleSourceBase;
import org.eclipse.rdf4j.federated.evaluation.iterator.FilteringInsertBindingsIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.FilteringIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.InsertBindingsIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.StatementConversionIteration;
import org.eclipse.rdf4j.federated.util.QueryAlgebraUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SailTripleSource
extends TripleSourceBase
implements TripleSource {
    private static final Logger log = LoggerFactory.getLogger(SailTripleSource.class);

    SailTripleSource(Endpoint endpoint, FederationContext federationContext) {
        super(federationContext, endpoint);
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> getStatements(String preparedQuery, BindingSet bindings, FilterValueExpr filterExpr) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        return this.withConnection((conn, resultHolder) -> {
            TupleQuery query = conn.prepareTupleQuery(QueryLanguage.SPARQL, preparedQuery, null);
            this.disableInference((Query)query);
            this.applyMaxExecutionTimeUpperBound((Operation)query);
            Object res = query.evaluate();
            resultHolder.set(res);
            if (filterExpr != null) {
                res = bindings.size() > 0 ? new FilteringInsertBindingsIteration(filterExpr, bindings, (CloseableIteration<BindingSet, QueryEvaluationException>)res, this.strategy) : new FilteringIteration(filterExpr, (CloseableIteration<BindingSet, QueryEvaluationException>)res, this.strategy);
                if (!res.hasNext()) {
                    Iterations.closeCloseable((Iteration)res);
                    resultHolder.set(new EmptyIteration());
                    return;
                }
            } else if (bindings.size() > 0) {
                res = new InsertBindingsIteration((CloseableIteration<BindingSet, QueryEvaluationException>)res, bindings);
            }
            resultHolder.set(res);
        });
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> getStatements(StatementPattern stmt, BindingSet bindings, FilterValueExpr filterExpr) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        Value subjValue = QueryAlgebraUtil.getVarValue(stmt.getSubjectVar(), bindings);
        Value predValue = QueryAlgebraUtil.getVarValue(stmt.getPredicateVar(), bindings);
        Value objValue = QueryAlgebraUtil.getVarValue(stmt.getObjectVar(), bindings);
        return this.withConnection((conn, resultHolder) -> {
            RepositoryResult repoResult = conn.getStatements((Resource)subjValue, (IRI)predValue, objValue, true, new Resource[0]);
            resultHolder.set(new StatementConversionIteration((RepositoryResult<Statement>)repoResult, bindings, stmt));
            if (filterExpr != null) {
                FilteringIteration filteredRes = new FilteringIteration(filterExpr, resultHolder.get(), this.strategy);
                if (!filteredRes.hasNext()) {
                    Iterations.closeCloseable((Iteration)filteredRes);
                    resultHolder.set(new EmptyIteration());
                    return;
                }
                resultHolder.set(filteredRes);
            }
        });
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        return this.withConnection((conn, resultHolder) -> {
            RepositoryResult repoResult = conn.getStatements(subj, pred, obj, true, new Resource[0]);
            resultHolder.set(new ExceptionConvertingIteration<Statement, QueryEvaluationException>((Iteration)repoResult){

                protected QueryEvaluationException convert(Exception arg0) {
                    return new QueryEvaluationException((Throwable)arg0);
                }
            });
        });
    }

    @Override
    public boolean hasStatements(StatementPattern stmt, BindingSet bindings) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        Value subjValue = QueryAlgebraUtil.getVarValue(stmt.getSubjectVar(), bindings);
        Value predValue = QueryAlgebraUtil.getVarValue(stmt.getPredicateVar(), bindings);
        Value objValue = QueryAlgebraUtil.getVarValue(stmt.getObjectVar(), bindings);
        try (RepositoryConnection conn = this.endpoint.getConnection();){
            boolean bl = conn.hasStatement((Resource)subjValue, (IRI)predValue, objValue, true, new Resource[0]);
            return bl;
        }
    }

    @Override
    public boolean usePreparedQuery() {
        return false;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> getStatements(TupleExpr preparedQuery, BindingSet bindings, FilterValueExpr filterExpr) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        return this.withConnection((conn, resultHolder) -> {
            Object res;
            SailConnection sailConn = ((SailRepositoryConnection)conn).getSailConnection();
            try {
                PrecompiledQueryNode precompiledQueryNode = new PrecompiledQueryNode(preparedQuery);
                res = sailConn.evaluate((TupleExpr)precompiledQueryNode, null, EmptyBindingSet.getInstance(), true);
            }
            catch (Exception e) {
                log.warn("Precompiled query optimization for native store could not be applied: " + e.getMessage());
                log.debug("Details:", (Throwable)e);
                res = sailConn.evaluate(preparedQuery, null, EmptyBindingSet.getInstance(), true);
            }
            if (bindings.size() > 0) {
                res = new InsertBindingsIteration((CloseableIteration<BindingSet, QueryEvaluationException>)res, bindings);
            }
            resultHolder.set(res);
        });
    }
}

