/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.federated.cache.Cache;
import org.eclipse.rdf4j.federated.cache.CacheEntry;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.exception.EntryAlreadyExistsException;
import org.eclipse.rdf4j.federated.exception.EntryUpdateException;
import org.eclipse.rdf4j.federated.exception.FedXException;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.federated.structures.SubQuery;
import org.eclipse.rdf4j.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCache
implements Cache {
    private static final Logger log = LoggerFactory.getLogger(MemoryCache.class);
    protected HashMap<SubQuery, CacheEntry> cache = new HashMap();
    protected File cacheLocation;

    public MemoryCache(File cacheLocation) {
        if (cacheLocation == null) {
            throw new FedXRuntimeException("The provided cacheLocation must not be null.");
        }
        this.cacheLocation = cacheLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(SubQuery subQuery, CacheEntry cacheEntry) throws EntryAlreadyExistsException {
        HashMap<SubQuery, CacheEntry> hashMap = this.cache;
        synchronized (hashMap) {
            if (this.cache.containsKey(subQuery)) {
                throw new EntryAlreadyExistsException("Entry for statement " + subQuery + " already exists in cache. Use update functionality instead.");
            }
            this.cache.put(subQuery, cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEntry(SubQuery subQuery, CacheEntry merge) throws EntryUpdateException {
        HashMap<SubQuery, CacheEntry> hashMap = this.cache;
        synchronized (hashMap) {
            CacheEntry entry = this.cache.get(subQuery);
            if (entry == null) {
                this.cache.put(subQuery, merge);
            } else {
                entry.merge(merge);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(SubQuery subQuery) throws EntryUpdateException {
        HashMap<SubQuery, CacheEntry> hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.remove(subQuery);
        }
    }

    @Override
    public Cache.StatementSourceAssurance canProvideStatements(SubQuery subQuery, Endpoint endpoint) {
        CacheEntry entry = this.cache.get(subQuery);
        if (entry == null) {
            return Cache.StatementSourceAssurance.POSSIBLY_HAS_STATEMENTS;
        }
        if (entry.hasLocalStatements(endpoint)) {
            return Cache.StatementSourceAssurance.HAS_LOCAL_STATEMENTS;
        }
        return entry.canProvideStatements(endpoint);
    }

    @Override
    public CacheEntry getCacheEntry(SubQuery subQuery) {
        CacheEntry entry = this.cache.get(subQuery);
        return entry;
    }

    @Override
    public CloseableIteration<? extends Statement, Exception> getStatements(SubQuery subQuery) {
        CacheEntry entry = this.cache.get(subQuery);
        return entry == null ? new EmptyIteration() : entry.getStatements();
    }

    @Override
    public CloseableIteration<? extends Statement, Exception> getStatements(SubQuery subQuery, Endpoint endpoint) {
        CacheEntry entry = this.cache.get(subQuery);
        return entry == null ? new CloseableIteration<Statement, Exception>() : entry.getStatements(endpoint);
    }

    @Override
    public List<Endpoint> hasLocalStatements(SubQuery subQuery) {
        CacheEntry entry = this.cache.get(subQuery);
        return entry == null ? Collections.emptyList() : entry.hasLocalStatements();
    }

    @Override
    public boolean hasLocalStatements(SubQuery subQuery, Endpoint endpoint) {
        CacheEntry entry = this.cache.get(subQuery);
        return entry == null ? false : entry.hasLocalStatements(endpoint);
    }

    @Override
    public void initialize() throws FedXException {
        if (!this.cacheLocation.exists()) {
            return;
        }
        try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.cacheLocation)));){
            this.cache = (HashMap)in.readObject();
        }
        catch (Exception e) {
            throw new FedXException("Error initializing cache.", e);
        }
    }

    @Override
    public void invalidate() throws FedXException {
        this.cache.clear();
    }

    @Override
    public void persist() throws FedXException {
        try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.cacheLocation)));){
            out.writeObject(this.cache);
        }
        catch (Exception e) {
            throw new FedXException("Error persisting cache data.", e);
        }
    }

    @Override
    public void clear() {
        log.debug("Clearing the cache.");
        this.cache = new HashMap();
    }
}

