/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.cache;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.cache.Cache;
import org.eclipse.rdf4j.federated.cache.CacheEntry;
import org.eclipse.rdf4j.federated.cache.CacheEntryImpl;
import org.eclipse.rdf4j.federated.cache.EndpointEntry;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.exception.OptimizationException;
import org.eclipse.rdf4j.federated.structures.SubQuery;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

public class CacheUtils {
    private static boolean checkEndpointForResults(Cache cache, Endpoint endpoint, Resource subj, IRI pred, Value obj) throws OptimizationException {
        try {
            TripleSource t = endpoint.getTripleSource();
            boolean hasResults = t.hasStatements(subj, pred, obj, new Resource[0]);
            CacheEntry entry = CacheUtils.createCacheEntry(endpoint, hasResults);
            cache.updateEntry(new SubQuery(subj, pred, obj), entry);
            return hasResults;
        }
        catch (Exception e) {
            throw new OptimizationException("Error checking results for endpoint " + endpoint.getId() + ": " + e.getMessage(), e);
        }
    }

    public static CacheEntry createCacheEntry(Endpoint e, boolean canProvideStatements) {
        CacheEntryImpl c = new CacheEntryImpl();
        c.add(new EndpointEntry(e.getId(), canProvideStatements));
        return c;
    }

    public static boolean checkCacheUpdateCache(Cache cache, List<Endpoint> endpoints, Resource subj, IRI pred, Value obj) {
        SubQuery q = new SubQuery(subj, pred, obj);
        for (Endpoint e : endpoints) {
            Cache.StatementSourceAssurance a = cache.canProvideStatements(q, e);
            if (a == Cache.StatementSourceAssurance.HAS_LOCAL_STATEMENTS || a == Cache.StatementSourceAssurance.HAS_REMOTE_STATEMENTS) {
                return true;
            }
            if (a != Cache.StatementSourceAssurance.POSSIBLY_HAS_STATEMENTS || !CacheUtils.checkEndpointForResults(cache, e, subj, pred, obj)) continue;
            return true;
        }
        return false;
    }

    public static List<StatementSource> checkCacheForStatementSourcesUpdateCache(Cache cache, List<Endpoint> endpoints, Resource subj, IRI pred, Value obj) {
        SubQuery q = new SubQuery(subj, pred, obj);
        ArrayList<StatementSource> sources = new ArrayList<StatementSource>(endpoints.size());
        for (Endpoint e : endpoints) {
            Cache.StatementSourceAssurance a = cache.canProvideStatements(q, e);
            if (a == Cache.StatementSourceAssurance.HAS_LOCAL_STATEMENTS) {
                sources.add(new StatementSource(e.getId(), StatementSource.StatementSourceType.LOCAL));
                continue;
            }
            if (a == Cache.StatementSourceAssurance.HAS_REMOTE_STATEMENTS) {
                sources.add(new StatementSource(e.getId(), StatementSource.StatementSourceType.REMOTE));
                continue;
            }
            if (a != Cache.StatementSourceAssurance.POSSIBLY_HAS_STATEMENTS || !CacheUtils.checkEndpointForResults(cache, e, subj, pred, obj)) continue;
            sources.add(new StatementSource(e.getId(), StatementSource.StatementSourceType.REMOTE));
        }
        return sources;
    }
}

