/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.cache.Cache;
import org.eclipse.rdf4j.federated.cache.CacheEntry;
import org.eclipse.rdf4j.federated.cache.EndpointEntry;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.exception.EntryUpdateException;
import org.eclipse.rdf4j.model.Statement;

public class CacheEntryImpl
implements CacheEntry {
    private static final long serialVersionUID = -2078321733800349639L;
    protected Map<String, EndpointEntry> entries = new HashMap<String, EndpointEntry>();

    @Override
    public Cache.StatementSourceAssurance canProvideStatements(Endpoint endpoint) {
        EndpointEntry entry = this.entries.get(endpoint.getId());
        return entry == null ? Cache.StatementSourceAssurance.POSSIBLY_HAS_STATEMENTS : (entry.doesProvideStatements() ? Cache.StatementSourceAssurance.HAS_REMOTE_STATEMENTS : Cache.StatementSourceAssurance.NONE);
    }

    @Override
    public CloseableIteration<? extends Statement, Exception> getStatements() {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    @Override
    public CloseableIteration<? extends Statement, Exception> getStatements(Endpoint endpoint) {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    @Override
    public List<Endpoint> hasLocalStatements() {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    @Override
    public boolean hasLocalStatements(Endpoint endpoint) {
        return false;
    }

    @Override
    public boolean isUpToDate() {
        return true;
    }

    @Override
    public void merge(CacheEntry other) throws EntryUpdateException {
        CacheEntryImpl o = (CacheEntryImpl)other;
        for (String k : o.entries.keySet()) {
            if (!this.entries.containsKey(k)) {
                this.entries.put(k, o.entries.get(k));
                continue;
            }
            EndpointEntry _merge = o.entries.get(k);
            EndpointEntry _old = this.entries.get(k);
            _old.setCanProvideStatements(_merge.doesProvideStatements());
        }
    }

    @Override
    public void update() throws EntryUpdateException {
        throw new UnsupportedOperationException("This operation is not yet supported.");
    }

    @Override
    public void add(EndpointEntry endpointEntry) {
        this.entries.put(endpointEntry.getEndpointID(), endpointEntry);
    }
}

