/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.cache;

import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.federated.cache.CacheEntry;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.exception.EntryAlreadyExistsException;
import org.eclipse.rdf4j.federated.exception.EntryUpdateException;
import org.eclipse.rdf4j.federated.exception.FedXException;
import org.eclipse.rdf4j.federated.structures.SubQuery;
import org.eclipse.rdf4j.model.Statement;

public interface Cache {
    public StatementSourceAssurance canProvideStatements(SubQuery var1, Endpoint var2);

    public List<Endpoint> hasLocalStatements(SubQuery var1);

    public boolean hasLocalStatements(SubQuery var1, Endpoint var2);

    public CacheEntry getCacheEntry(SubQuery var1);

    public CloseableIteration<? extends Statement, Exception> getStatements(SubQuery var1);

    public CloseableIteration<? extends Statement, Exception> getStatements(SubQuery var1, Endpoint var2);

    public void initialize() throws FedXException;

    public void invalidate() throws FedXException;

    public void persist() throws FedXException;

    public void addEntry(SubQuery var1, CacheEntry var2) throws EntryAlreadyExistsException;

    public void updateEntry(SubQuery var1, CacheEntry var2) throws EntryUpdateException;

    public void removeEntry(SubQuery var1) throws EntryUpdateException;

    public void clear();

    public static enum StatementSourceAssurance {
        NONE,
        HAS_LOCAL_STATEMENTS,
        HAS_REMOTE_STATEMENTS,
        POSSIBLY_HAS_STATEMENTS;

    }
}

