/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated;

import org.eclipse.rdf4j.federated.EndpointManager;
import org.eclipse.rdf4j.federated.FedX;
import org.eclipse.rdf4j.federated.FedXConfig;
import org.eclipse.rdf4j.federated.FederationManager;
import org.eclipse.rdf4j.federated.QueryManager;
import org.eclipse.rdf4j.federated.cache.Cache;
import org.eclipse.rdf4j.federated.evaluation.DelegateFederatedServiceResolver;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.monitoring.Monitoring;

public class FederationContext {
    private final FederationManager manager;
    private final EndpointManager endpointManager;
    private final Monitoring monitoring;
    private final QueryManager queryManager;
    private final Cache cache;
    private final DelegateFederatedServiceResolver serviceResolver;
    private final FedXConfig fedXConfig;

    public FederationContext(FederationManager manager, EndpointManager endpointManager, QueryManager queryManager, Cache cache, DelegateFederatedServiceResolver federatedServiceResolver, Monitoring monitoring, FedXConfig fedXConfig) {
        this.manager = manager;
        this.endpointManager = endpointManager;
        this.queryManager = queryManager;
        this.cache = cache;
        this.serviceResolver = federatedServiceResolver;
        this.monitoring = monitoring;
        this.fedXConfig = fedXConfig;
    }

    public FedX getFederation() {
        return this.manager.getFederation();
    }

    public Cache getCache() {
        return this.cache;
    }

    public FederationManager getManager() {
        return this.manager;
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    public EndpointManager getEndpointManager() {
        return this.endpointManager;
    }

    public FederationEvalStrategy getStrategy() {
        return this.manager.getStrategy();
    }

    public Monitoring getMonitoringService() {
        return this.monitoring;
    }

    public DelegateFederatedServiceResolver getFederatedServiceResolver() {
        return this.serviceResolver;
    }

    public FedXConfig getConfig() {
        return this.fedXConfig;
    }
}

