/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.tx;

import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.sail.Sail;
import org.springframework.transaction.InvalidIsolationLevelException;

public class IsolationLevelAdapter {
    static IsolationLevel adaptToRdfIsolation(Sail sail, int springIsolation) {
        switch (springIsolation) {
            case -1: {
                return sail.getDefaultIsolationLevel();
            }
            case 2: {
                return IsolationLevelAdapter.determineIsolationLevel(sail, (IsolationLevel)IsolationLevels.READ_COMMITTED);
            }
            case 1: {
                return IsolationLevelAdapter.determineIsolationLevel(sail, (IsolationLevel)IsolationLevels.READ_UNCOMMITTED);
            }
            case 4: {
                throw new InvalidIsolationLevelException("Unsupported isolation level for sail: " + String.valueOf(sail) + ": " + springIsolation);
            }
            case 8: {
                return IsolationLevelAdapter.determineIsolationLevel(sail, (IsolationLevel)IsolationLevels.SERIALIZABLE);
            }
        }
        throw new InvalidIsolationLevelException("Unsupported isolation level for sail: " + String.valueOf(sail) + ": " + springIsolation);
    }

    private static IsolationLevel determineIsolationLevel(Sail sail, IsolationLevel isolationLevel) {
        if (sail.getSupportedIsolationLevels().contains(isolationLevel)) {
            return isolationLevel;
        }
        throw new InvalidIsolationLevelException("Unsupported isolation level for sail: " + String.valueOf(sail) + ": " + String.valueOf(isolationLevel));
    }
}

