/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.support;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.spring.dao.exception.RDF4JSpringException;
import org.eclipse.rdf4j.spring.support.connectionfactory.RepositoryConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Experimental
@Component
public class DataInserter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    RepositoryConnectionFactory connectionFactory;

    @Transactional(propagation=Propagation.REQUIRED)
    public void insertData(org.springframework.core.io.Resource dataFile) {
        Objects.requireNonNull(dataFile);
        logger.debug("Loading data from {}...", (Object)dataFile);
        try {
            RepositoryConnection con = this.connectionFactory.getConnection();
            RDFFormat fmt = (RDFFormat)Rio.getParserFormatForFileName((String)dataFile.getFilename()).orElseThrow(() -> new IllegalArgumentException("Failed to determine file format of input file " + String.valueOf(dataFile)));
            con.add(dataFile.getInputStream(), "", fmt, new Resource[0]);
        }
        catch (Exception e) {
            throw new RDF4JSpringException("Unable to load test data", e);
        }
        logger.debug("\tdone loading data");
    }
}

