/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.dao.support;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.sparqlbuilder.core.Assignable;
import org.eclipse.rdf4j.sparqlbuilder.core.Projectable;
import org.eclipse.rdf4j.sparqlbuilder.core.SparqlBuilder;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.sparqlbuilder.core.query.Queries;
import org.eclipse.rdf4j.sparqlbuilder.core.query.SelectQuery;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfObject;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicate;
import org.eclipse.rdf4j.spring.dao.support.bindingsBuilder.BindingsBuilder;
import org.eclipse.rdf4j.spring.dao.support.opbuilder.TupleQueryEvaluationBuilder;
import org.eclipse.rdf4j.spring.support.RDF4JTemplate;
import org.eclipse.rdf4j.spring.util.QueryResultUtils;

public class RelationMapBuilder {
    public static final Variable _relSubject = SparqlBuilder.var((String)"rel_subject");
    public static final Variable _relObject = SparqlBuilder.var((String)"rel_object");
    private static final Variable _relKey = SparqlBuilder.var((String)"rel_key");
    private static final Variable _relValue = SparqlBuilder.var((String)"rel_value");
    private static final IRI NOTHING = SimpleValueFactory.getInstance().createIRI("urn:java:relationDaoSupport:Nothing");
    private final RdfPredicate predicate;
    private GraphPattern[] constraints = new GraphPattern[0];
    private final RDF4JTemplate rdf4JTemplate;
    private boolean isRelationOptional = false;
    private boolean isSubjectKeyed = true;
    private final BindingsBuilder bindingsBuilder = new BindingsBuilder();

    public RelationMapBuilder(RDF4JTemplate rdf4JTemplate, RdfPredicate predicate) {
        this.rdf4JTemplate = rdf4JTemplate;
        this.predicate = predicate;
    }

    public RelationMapBuilder(RDF4JTemplate rdf4JTemplate, IRI predicate) {
        this.rdf4JTemplate = rdf4JTemplate;
        this.predicate = Rdf.iri((IRI)predicate);
    }

    public RelationMapBuilder constraints(GraphPattern ... constraints) {
        this.constraints = constraints;
        return this;
    }

    public RelationMapBuilder relationIsOptional() {
        this.isRelationOptional = true;
        return this;
    }

    public RelationMapBuilder useRelationObjectAsKey() {
        this.isSubjectKeyed = false;
        return this;
    }

    public Map<IRI, IRI> buildOneToOne() {
        return this.makeTupleQueryBuilder().evaluateAndConvert().toMap(b -> QueryResultUtils.getIRI(b, _relKey), this::getRelationValueOrNothing);
    }

    public Map<IRI, Set<IRI>> buildOneToMany() {
        return this.makeTupleQueryBuilder().evaluateAndConvert().mapAndCollect(Function.identity(), Collectors.toMap(b -> QueryResultUtils.getIRI(b, _relKey), b -> QueryResultUtils.getIRIOptional(b, _relValue).map(Set::of).orElseGet(Set::of), RelationMapBuilder::mergeSets));
    }

    private static <T> Set<T> mergeSets(Set<T> left, Set<T> right) {
        HashSet<T> merged = new HashSet<T>(left);
        merged.addAll(right);
        return merged;
    }

    private IRI getRelationValue(BindingSet b) {
        if (this.isRelationOptional) {
            return QueryResultUtils.getIRIOptional(b, _relValue).orElse(NOTHING);
        }
        return QueryResultUtils.getIRI(b, _relValue);
    }

    private IRI getRelationValueOrNothing(BindingSet b) {
        if (this.isRelationOptional) {
            return QueryResultUtils.getIRIOptional(b, _relValue).orElse(NOTHING);
        }
        return QueryResultUtils.getIRI(b, _relValue);
    }

    private TupleQueryEvaluationBuilder makeTupleQueryBuilder() {
        return (TupleQueryEvaluationBuilder)this.rdf4JTemplate.tupleQuery(this.makeQueryString()).withBindings(this.bindingsBuilder.build());
    }

    String makeQueryString() {
        return ((SelectQuery)Queries.SELECT((Projectable[])this.getProjection()).where(this.getWhereClause())).distinct().getQueryString();
    }

    private Projectable[] getProjection() {
        if (this.isSubjectKeyed) {
            return new Projectable[]{SparqlBuilder.as((Assignable)_relSubject, (Variable)_relKey), SparqlBuilder.as((Assignable)_relObject, (Variable)_relValue)};
        }
        return new Projectable[]{SparqlBuilder.as((Assignable)_relSubject, (Variable)_relValue), SparqlBuilder.as((Assignable)_relObject, (Variable)_relKey)};
    }

    private GraphPattern[] getWhereClause() {
        TriplePattern tp = _relSubject.has(this.predicate, new RdfObject[]{_relObject});
        GraphPattern[] ret = new GraphPattern[this.constraints.length + 1];
        ret[this.constraints.length] = this.isRelationOptional ? tp.optional() : tp;
        System.arraycopy(this.constraints, 0, ret, 0, this.constraints.length);
        return ret;
    }

    public RelationMapBuilder withBinding(Variable key, Value value) {
        this.bindingsBuilder.add(key, value);
        return this;
    }

    public RelationMapBuilder withBinding(String key, Value value) {
        this.bindingsBuilder.add(key, value);
        return this;
    }

    public RelationMapBuilder withBindingMaybe(Variable key, Value value) {
        this.bindingsBuilder.addMaybe(key, value);
        return this;
    }

    public RelationMapBuilder withBindingMaybe(String key, Value value) {
        this.bindingsBuilder.addMaybe(key, value);
        return this;
    }

    public RelationMapBuilder withBinding(Variable key, IRI value) {
        this.bindingsBuilder.add(key, value);
        return this;
    }

    public RelationMapBuilder withBinding(String key, IRI value) {
        this.bindingsBuilder.add(key, value);
        return this;
    }

    public RelationMapBuilder withBindingMaybe(Variable key, IRI value) {
        this.bindingsBuilder.addMaybe(key, value);
        return this;
    }

    public RelationMapBuilder withBindingMaybe(Variable key, String value) {
        this.bindingsBuilder.addMaybe(key, value);
        return this;
    }

    public RelationMapBuilder withBindingMaybe(String key, IRI value) {
        this.bindingsBuilder.addMaybe(key, value);
        return this;
    }

    public RelationMapBuilder withBinding(Variable key, String value) {
        this.bindingsBuilder.add(key, value);
        return this;
    }

    public RelationMapBuilder withBinding(String key, String value) {
        this.bindingsBuilder.add(key, value);
        return this;
    }

    public RelationMapBuilder withBindingMaybe(String key, String value) {
        this.bindingsBuilder.addMaybe(key, value);
        return this;
    }

    public RelationMapBuilder withBinding(Variable key, Integer value) {
        this.bindingsBuilder.add(key, value);
        return this;
    }

    public RelationMapBuilder withBinding(String key, Integer value) {
        this.bindingsBuilder.add(key, value);
        return this;
    }

    public RelationMapBuilder withBindingMaybe(Variable key, Integer value) {
        this.bindingsBuilder.addMaybe(key, value);
        return this;
    }

    public RelationMapBuilder withBindingMaybe(String key, Integer value) {
        this.bindingsBuilder.addMaybe(key, value);
        return this;
    }

    public RelationMapBuilder withBinding(Variable key, Boolean value) {
        this.bindingsBuilder.add(key, value);
        return this;
    }

    public RelationMapBuilder withBinding(String key, Boolean value) {
        this.bindingsBuilder.add(key, value);
        return this;
    }

    public RelationMapBuilder withBindingMaybe(Variable key, Boolean value) {
        this.bindingsBuilder.addMaybe(key, value);
        return this;
    }

    public RelationMapBuilder withBindingMaybe(String key, Boolean value) {
        this.bindingsBuilder.addMaybe(key, value);
        return this;
    }

    public RelationMapBuilder withBinding(Variable key, Float value) {
        this.bindingsBuilder.add(key, value);
        return this;
    }

    public RelationMapBuilder withBinding(String key, Float value) {
        this.bindingsBuilder.add(key, value);
        return this;
    }

    public RelationMapBuilder withBindingMaybe(Variable key, Float value) {
        this.bindingsBuilder.addMaybe(key, value);
        return this;
    }

    public RelationMapBuilder withBindingMaybe(String key, Float value) {
        this.bindingsBuilder.addMaybe(key, value);
        return this;
    }

    public RelationMapBuilder withBinding(Variable key, Double value) {
        this.bindingsBuilder.add(key, value);
        return this;
    }

    public RelationMapBuilder withBinding(String key, Double value) {
        this.bindingsBuilder.add(key, value);
        return this;
    }

    public RelationMapBuilder withBindingMaybe(Variable var, Double value) {
        this.bindingsBuilder.addMaybe(var, value);
        return this;
    }

    public RelationMapBuilder withBindingMaybe(String key, Double value) {
        this.bindingsBuilder.addMaybe(key, value);
        return this;
    }
}

