/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.operationlog.log;

import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.spring.operationlog.log.OperationExecutionStats;
import org.eclipse.rdf4j.spring.operationlog.log.OperationExecutionStatsConsumer;
import org.eclipse.rdf4j.spring.operationlog.log.PseudoOperation;
import org.eclipse.rdf4j.spring.operationlog.log.slf4j.DebuggingOperationExecutionStatsConsumer;
import org.springframework.beans.factory.annotation.Autowired;

public class OperationLog {
    private OperationExecutionStatsConsumer statsConsumer;

    public OperationLog(OperationExecutionStatsConsumer statsConsumer) {
        Objects.requireNonNull(statsConsumer);
        this.statsConsumer = statsConsumer;
    }

    @Autowired(required=false)
    public void setStatsConsumer(OperationExecutionStatsConsumer statsConsumer) {
        this.statsConsumer = statsConsumer;
    }

    public OperationLog() {
        this.statsConsumer = new DebuggingOperationExecutionStatsConsumer();
    }

    public void runWithLog(Operation operation, Runnable action) {
        this.runWithLog(this.makeStats(operation), action);
    }

    public <T> T runWithLog(Operation operation, Supplier<T> supplier) {
        return this.runWithLog(this.makeStats(operation), supplier);
    }

    public void runWithLog(PseudoOperation operation, Runnable action) {
        this.runWithLog(this.makeStats(operation), action);
    }

    public <T> T runWithLog(PseudoOperation operation, Supplier<T> supplier) {
        return this.runWithLog(this.makeStats(operation), supplier);
    }

    private OperationExecutionStats makeStats(Operation operation) {
        Objects.requireNonNull(operation);
        return OperationExecutionStats.of(operation);
    }

    private OperationExecutionStats makeStats(PseudoOperation operation) {
        Objects.requireNonNull(operation);
        return OperationExecutionStats.of(operation);
    }

    private void runWithLog(OperationExecutionStats stats, Runnable action) {
        Objects.requireNonNull(action);
        try {
            action.run();
            stats.operationSuccessful();
        }
        catch (Throwable t) {
            stats.operationFailed();
            throw t;
        }
        finally {
            this.statsConsumer.consumeOperationExecutionStats(stats);
        }
    }

    private <T> T runWithLog(OperationExecutionStats stats, Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        try {
            T result = supplier.get();
            stats.operationSuccessful();
            T t = result;
            return t;
        }
        catch (Throwable t) {
            stats.operationFailed();
            throw t;
        }
        finally {
            this.statsConsumer.consumeOperationExecutionStats(stats);
        }
    }
}

