/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.dao.support.opbuilder;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.spring.dao.support.bindingsBuilder.BindingsBuilder;
import org.eclipse.rdf4j.spring.support.RDF4JTemplate;

public class OperationBuilder<T extends Operation, SUB extends OperationBuilder<T, SUB>> {
    private final T operation;
    private final BindingsBuilder bindingsBuilder = new BindingsBuilder();
    private final RDF4JTemplate rdf4JTemplate;

    public OperationBuilder(T operation, RDF4JTemplate template) {
        Objects.requireNonNull(operation);
        this.operation = operation;
        this.rdf4JTemplate = template;
    }

    protected T getOperation() {
        return this.operation;
    }

    protected RDF4JTemplate getRdf4JTemplate() {
        return this.rdf4JTemplate;
    }

    protected Map<String, Value> getBindings() {
        return this.bindingsBuilder.build();
    }

    public SUB withBinding(Variable key, IRI value) {
        this.bindingsBuilder.add(key, value);
        return (SUB)this;
    }

    public SUB withBinding(String key, IRI value) {
        this.bindingsBuilder.add(key, value);
        return (SUB)this;
    }

    public SUB withBinding(Variable key, String value) {
        this.bindingsBuilder.add(key, value);
        return (SUB)this;
    }

    public SUB withBinding(String key, String value) {
        this.bindingsBuilder.add(key, value);
        return (SUB)this;
    }

    public SUB withBinding(Variable key, Integer value) {
        this.bindingsBuilder.add(key, value);
        return (SUB)this;
    }

    public SUB withBinding(String key, Integer value) {
        this.bindingsBuilder.add(key, value);
        return (SUB)this;
    }

    public SUB withBinding(Variable key, Boolean value) {
        this.bindingsBuilder.add(key, value);
        return (SUB)this;
    }

    public SUB withBinding(String key, Boolean value) {
        this.bindingsBuilder.add(key, value);
        return (SUB)this;
    }

    public SUB withBinding(Variable key, Float value) {
        this.bindingsBuilder.add(key, value);
        return (SUB)this;
    }

    public SUB withBinding(String key, Float value) {
        this.bindingsBuilder.add(key, value);
        return (SUB)this;
    }

    public SUB withBinding(Variable key, Double value) {
        this.bindingsBuilder.add(key, value);
        return (SUB)this;
    }

    public SUB withBinding(String key, Double value) {
        this.bindingsBuilder.add(key, value);
        return (SUB)this;
    }

    public SUB withBinding(String key, Value value) {
        this.bindingsBuilder.add(key, value);
        return (SUB)this;
    }

    public SUB withBindings(Map<String, Value> bindings) {
        bindings.forEach((key, value) -> this.bindingsBuilder.add((String)key, (Value)value));
        return (SUB)this;
    }

    public SUB withNullableBindings(Map<String, Value> bindings) {
        if (bindings != null) {
            bindings.forEach((key, value) -> this.bindingsBuilder.add((String)key, (Value)value));
        }
        return (SUB)this;
    }

    public SUB withBindings(Consumer<BindingsBuilder> consumer) {
        consumer.accept(this.bindingsBuilder);
        return (SUB)this;
    }
}

