/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.dao.support;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.AbstractStatement;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.util.ModelBuilder;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.spring.support.RDF4JTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateWithModelBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final RepositoryConnection con;
    private final ModelBuilder modelBuilder;
    private final Model addModel;
    private final Set<Statement> removeStatements;

    public UpdateWithModelBuilder(RepositoryConnection con) {
        this.con = con;
        this.addModel = new LinkedHashModel();
        this.removeStatements = new HashSet<Statement>();
        this.modelBuilder = new ModelBuilder(this.addModel);
    }

    public static UpdateWithModelBuilder fromTemplate(RDF4JTemplate template) {
        return template.applyToConnection(con -> new UpdateWithModelBuilder((RepositoryConnection)con));
    }

    public UpdateWithModelBuilder remove(Resource subject, IRI predicate, Value object, Resource ... resources) {
        this.addModel.remove(subject, predicate, object, resources);
        if (resources.length == 0) {
            this.removeStatements.add((Statement)new WildcardAllowingStatement(subject, predicate, object, null));
        } else {
            for (int i = 0; i < resources.length; ++i) {
                this.removeStatements.add((Statement)new WildcardAllowingStatement(subject, predicate, object, resources[i]));
            }
        }
        return this;
    }

    public UpdateWithModelBuilder setNamespace(Namespace ns) {
        this.modelBuilder.setNamespace(ns);
        return this;
    }

    public UpdateWithModelBuilder setNamespace(String prefix, String namespace) {
        this.modelBuilder.setNamespace(prefix, namespace);
        return this;
    }

    public UpdateWithModelBuilder subject(Resource subject) {
        this.modelBuilder.subject(subject);
        return this;
    }

    public UpdateWithModelBuilder subject(String prefixedNameOrIri) {
        this.modelBuilder.subject(prefixedNameOrIri);
        return this;
    }

    public UpdateWithModelBuilder namedGraph(Resource namedGraph) {
        this.modelBuilder.namedGraph(namedGraph);
        return this;
    }

    public UpdateWithModelBuilder namedGraph(String prefixedNameOrIRI) {
        this.modelBuilder.namedGraph(prefixedNameOrIRI);
        return this;
    }

    public UpdateWithModelBuilder defaultGraph() {
        this.modelBuilder.defaultGraph();
        return this;
    }

    public UpdateWithModelBuilder addMaybe(Resource subject, IRI predicate, Object object) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{subject, predicate, object})) {
            return this.add(subject, predicate, object);
        }
        return this;
    }

    public UpdateWithModelBuilder add(Resource subject, IRI predicate, Object object) {
        this.modelBuilder.add(subject, predicate, object);
        return this;
    }

    public UpdateWithModelBuilder addMaybe(String subject, IRI predicate, Object object) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{subject, predicate, object})) {
            return this.add(subject, predicate, object);
        }
        return this;
    }

    public UpdateWithModelBuilder add(String subject, IRI predicate, Object object) {
        this.modelBuilder.add(subject, predicate, object);
        return this;
    }

    public UpdateWithModelBuilder addMaybe(String subject, String predicate, Object object) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{subject, predicate, object})) {
            return this.add(subject, predicate, object);
        }
        return this;
    }

    public UpdateWithModelBuilder add(String subject, String predicate, Object object) {
        this.modelBuilder.add(subject, predicate, object);
        return this;
    }

    public UpdateWithModelBuilder addMaybe(IRI predicate, Object object) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{predicate, object})) {
            return this.add(predicate, object);
        }
        return this;
    }

    public UpdateWithModelBuilder add(IRI predicate, Object object) {
        this.modelBuilder.add(predicate, object);
        return this;
    }

    public UpdateWithModelBuilder addMaybe(String predicate, Object object) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{predicate, object})) {
            return this.add(predicate, object);
        }
        return this;
    }

    public UpdateWithModelBuilder add(String predicate, Object object) {
        this.modelBuilder.add(predicate, object);
        return this;
    }

    public void acceptConnection(Consumer<RepositoryConnection> connectionConsumer) {
        connectionConsumer.accept(this.con);
    }

    public <T> T applyToConnection(Function<RepositoryConnection, T> function) {
        return function.apply(this.con);
    }

    public BNode createBNode() {
        return this.con.getValueFactory().createBNode();
    }

    public UpdateWithModelBuilder withSink(Consumer<Collection<Statement>> consumer) {
        ArrayList sink = new ArrayList();
        consumer.accept(sink);
        if (!sink.isEmpty()) {
            sink.stream().forEach(s -> this.modelBuilder.add(s.getSubject(), s.getPredicate(), (Object)s.getObject()));
        }
        return this;
    }

    public void execute() {
        Model model = this.modelBuilder.build();
        if (logger.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            Rio.write(this.removeStatements, (Writer)sw, (RDFFormat)RDFFormat.TURTLE);
            logger.debug("removing the following triples:\n{}", (Object)sw.toString());
            sw = new StringWriter();
            Rio.write((Iterable)model, (Writer)sw, (RDFFormat)RDFFormat.TURTLE);
            logger.debug("adding the following triples:\n{}", (Object)sw.toString());
        }
        this.con.remove(this.removeStatements, new Resource[0]);
        this.con.add((Iterable)this.addModel, new Resource[0]);
    }

    static class WildcardAllowingStatement
    extends AbstractStatement {
        private static final long serialVersionUID = -4116676621136121342L;
        private final Resource subject;
        private final IRI predicate;
        private final Value object;
        private final Resource context;

        WildcardAllowingStatement(Resource subject, IRI predicate, Value object, Resource context) {
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
            this.context = context;
        }

        public Resource getSubject() {
            return this.subject;
        }

        public IRI getPredicate() {
            return this.predicate;
        }

        public Value getObject() {
            return this.object;
        }

        public Resource getContext() {
            return this.context;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            WildcardAllowingStatement that = (WildcardAllowingStatement)((Object)o);
            return Objects.equals(this.getSubject(), that.getSubject()) && Objects.equals(this.getPredicate(), that.getPredicate()) && Objects.equals(this.getObject(), that.getObject()) && Objects.equals(this.getContext(), that.getContext());
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getSubject(), this.getPredicate(), this.getObject(), this.getContext());
        }
    }
}

