/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.repository.inmemory;

import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.spring.repository.inmemory.InMemoryRepositoryProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={InMemoryRepositoryProperties.class})
@ConditionalOnProperty(value={"rdf4j.spring.repository.inmemory.enabled"})
public class InMemoryRepositoryConfig {
    @Bean
    public Repository getInMemoryRepository(@Autowired InMemoryRepositoryProperties repositoryProperties) {
        if (repositoryProperties.isUseShaclSail()) {
            return new SailRepository((Sail)new ShaclSail((NotifyingSail)new MemoryStore()));
        }
        return new SailRepository((Sail)new MemoryStore());
    }
}

