/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.resultcache;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.map.LRUMap;
import org.eclipse.rdf4j.spring.resultcache.ResultCache;
import org.eclipse.rdf4j.spring.resultcache.ResultCacheProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LRUResultCache<T>
implements ResultCache<Integer, T> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<Integer, Entry<T>> cache;
    private final AtomicBoolean dirty = new AtomicBoolean(false);
    private final Map<Thread, Boolean> bypassInThread = Collections.synchronizedMap(new WeakHashMap());
    private final Duration entryLifetime;

    public LRUResultCache(ResultCacheProperties properties) {
        this.entryLifetime = properties.getEntryLifetime();
        this.cache = Collections.synchronizedMap(new LRUMap(properties.getMaxSize(), properties.getInitialSize()));
    }

    @Override
    public T get(Integer key) {
        this.debug("obtaining cached result for key {} from cache {}", key, this.hashCode());
        Objects.requireNonNull(key);
        if (this.dirty.get()) {
            this.debug("cache is dirty", new Object[0]);
            this.clearCachedResults();
            this.debug("returning null", new Object[0]);
            return null;
        }
        if (this.isBypass()) {
            this.debug("bypassing cache, returning null", new Object[0]);
            return null;
        }
        Entry<T> entry = this.cache.get(key);
        if (entry == null) {
            this.debug("nothing found in cache, returning null", new Object[0]);
            return null;
        }
        if (entry.isExpired()) {
            this.cache.remove(key);
            this.debug("cached object is expired, returning null", new Object[0]);
            return null;
        }
        this.debug("returning cached object", new Object[0]);
        return entry.getCachedObject();
    }

    private void debug(String message, Object ... args) {
        if (logger.isDebugEnabled()) {
            logger.debug(message, args);
        }
    }

    private boolean isBypass() {
        return this.bypassInThread.containsKey(Thread.currentThread());
    }

    @Override
    public void put(Integer key, T cachedObject) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(cachedObject);
        this.debug("about to put object {} into cache {}", key, this.hashCode());
        if (this.isBypass()) {
            this.debug("bypassing cache, not caching object", new Object[0]);
            return;
        }
        if (this.dirty.get()) {
            this.debug("cache is dirty", new Object[0]);
            this.clearCachedResults();
        }
        this.debug("putting object into cache", new Object[0]);
        this.cache.put(key, new Entry<T>(cachedObject));
    }

    @Override
    public void markDirty() {
        this.debug("marking dirty: cache {}", this.hashCode());
        this.dirty.set(true);
    }

    @Override
    public synchronized void clearCachedResults() {
        this.debug("clearing cache {}", this.hashCode());
        if (this.dirty.get()) {
            this.cache.clear();
            this.bypassInThread.clear();
            this.dirty.set(false);
        }
    }

    @Override
    public void bypassForCurrentThread() {
        this.bypassInThread.put(Thread.currentThread(), true);
    }

    private class Entry<E> {
        E cachedObject;
        Instant createdAtTimestamp = Instant.now();

        public Entry(E cachedObject) {
            this.cachedObject = cachedObject;
        }

        public E getCachedObject() {
            return this.cachedObject;
        }

        public boolean isExpired() {
            return this.createdAtTimestamp.plus(LRUResultCache.this.entryLifetime).isBefore(Instant.now());
        }
    }
}

