/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.dao.support.operation;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.spring.dao.exception.IncorrectResultSetSizeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationUtils {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static <T> Optional<T> atMostOne(Collection<T> objects) {
        int size = objects.size();
        if (size > 1) {
            throw new IncorrectResultSetSizeException("Expected to find at most one entity, but found " + size, 1, size);
        }
        return objects.stream().findFirst();
    }

    public static <T> T require(Optional<T> required) {
        if (required.isEmpty()) {
            throw new IncorrectResultSetSizeException("Expected to find exactly one entity but found 0", 1, 0);
        }
        return required.get();
    }

    public static <T> T exactlyOne(Collection<T> objects) {
        return OperationUtils.require(OperationUtils.atMostOne(objects));
    }

    public static <T> Collector<T, ?, T> toSingleton() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            int size = list.size();
            if (size != 1) {
                throw new IncorrectResultSetSizeException("Expected exactly one result, found " + size, 1, size);
            }
            return list.get(0);
        });
    }

    public static <T> Collector<T, ?, T> toSingletonMaybe() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            int size = list.size();
            if (size > 1) {
                throw new IncorrectResultSetSizeException("Expected zero or one result, found " + size, 1, size);
            }
            if (size == 0) {
                return null;
            }
            return list.get(0);
        });
    }

    public static <T> Collector<T, ?, Optional<T>> toSingletonOptional() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            int size = list.size();
            if (size > 1) {
                throw new IncorrectResultSetSizeException("Expected zero or one result, found " + size, 1, 0);
            }
            if (size == 0) {
                return Optional.empty();
            }
            return Optional.ofNullable(list.get(0));
        });
    }

    public static void setBindings(Operation operation, Map<String, Value> bindings) {
        OperationUtils.debugLogBindings(bindings);
        operation.clearBindings();
        if (bindings != null) {
            bindings.entrySet().stream().forEach(entry -> operation.setBinding((String)entry.getKey(), (Value)entry.getValue()));
        }
    }

    private static void debugLogBindings(Map<String, Value> bindings) {
        if (logger.isDebugEnabled() && bindings != null) {
            logger.debug("bindings: {}", bindings);
            List keys = bindings.keySet().stream().collect(Collectors.toList());
            logger.debug("values block:\n\nVALUES ( {} ) { ( {} ) }\n", (Object)keys.stream().map(k -> "?" + k).collect(Collectors.joining(" ")), (Object)keys.stream().map(k -> Rdf.object((Value)((Value)bindings.get(k))).getQueryString()).collect(Collectors.joining(" ")));
        }
    }
}

