/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.resultcache;

import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.spring.resultcache.Clearable;
import org.eclipse.rdf4j.spring.support.query.DelegatingUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearableAwareUpdate
extends DelegatingUpdate {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    WeakReference<Clearable> clearableRef;

    public ClearableAwareUpdate(Update delegate, Clearable clearable) {
        super(delegate);
        this.clearableRef = new WeakReference<Clearable>(clearable);
    }

    @Override
    public void execute() throws UpdateExecutionException {
        super.execute();
        Clearable clearable = (Clearable)this.clearableRef.get();
        if (clearable == null) {
            logger.debug("update executed, but reference to clearable (i.e. result-caching connection) is gone - cannot mark it dirty");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("marking Dirty: instance {} of type {}", (Object)this.hashCode(), (Object)clearable.getClass().getSimpleName());
        }
        clearable.markDirty();
    }

    public void renewClearable(Clearable clearable) {
        this.clearableRef = new WeakReference<Clearable>(clearable);
    }
}

