/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.dao.support.bindingsBuilder;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.spring.dao.support.bindingsBuilder.MutableBindings;

public class BindingsBuilder
implements MutableBindings {
    private final Map<String, Value> bindings;

    public BindingsBuilder() {
        this.bindings = new HashMap<String, Value>();
    }

    public BindingsBuilder(Map<String, Value> bindings) {
        this.bindings = bindings;
    }

    public Map<String, Value> build() {
        return this.bindings;
    }

    @Override
    public BindingsBuilder add(Variable key, Value value) {
        return this.add(key.getVarName(), value);
    }

    @Override
    public BindingsBuilder add(String key, Value value) {
        Objects.requireNonNull(value);
        return this.addMaybe(key, value);
    }

    @Override
    public BindingsBuilder addMaybe(Variable key, Value value) {
        return this.addMaybe(key.getVarName(), value);
    }

    @Override
    public BindingsBuilder addMaybe(String key, Value value) {
        this.checkKeyNotPresent(key);
        if (value != null) {
            this.bindings.put(key, value);
        }
        return this;
    }

    @Override
    public BindingsBuilder add(Variable key, IRI value) {
        return this.add(key.getVarName(), value);
    }

    @Override
    public BindingsBuilder add(String key, IRI value) {
        Objects.requireNonNull(value);
        return this.addMaybe(key, value);
    }

    @Override
    public BindingsBuilder addMaybe(Variable key, IRI value) {
        return this.addMaybe(key.getVarName(), value);
    }

    @Override
    public BindingsBuilder addMaybe(Variable key, String value) {
        return this.addMaybe(key.getVarName(), value);
    }

    @Override
    public BindingsBuilder addMaybe(String key, IRI value) {
        this.checkKeyNotPresent(key);
        if (value != null) {
            this.bindings.put(key, (Value)value);
        }
        return this;
    }

    @Override
    public BindingsBuilder add(Variable key, String value) {
        return this.add(key.getVarName(), value);
    }

    @Override
    public BindingsBuilder add(String key, String value) {
        Objects.requireNonNull(value);
        return this.addMaybe(key, value);
    }

    @Override
    public BindingsBuilder addMaybe(String key, String value) {
        this.checkKeyNotPresent(key);
        if (value != null) {
            this.bindings.put(key, (Value)SimpleValueFactory.getInstance().createLiteral(value));
        }
        return this;
    }

    @Override
    public BindingsBuilder add(Variable key, Integer value) {
        return this.add(key.getVarName(), value);
    }

    @Override
    public BindingsBuilder add(String key, Integer value) {
        Objects.requireNonNull(value);
        return this.addMaybe(key, value);
    }

    @Override
    public BindingsBuilder addMaybe(Variable key, Integer value) {
        return this.addMaybe(key.getVarName(), value);
    }

    @Override
    public BindingsBuilder addMaybe(String key, Integer value) {
        this.checkKeyNotPresent(key);
        if (value != null) {
            this.bindings.put(key, (Value)SimpleValueFactory.getInstance().createLiteral(value.intValue()));
        }
        return this;
    }

    @Override
    public BindingsBuilder add(Variable key, Boolean value) {
        return this.add(key.getVarName(), value);
    }

    @Override
    public BindingsBuilder add(String key, Boolean value) {
        Objects.requireNonNull(value);
        return this.addMaybe(key, value);
    }

    @Override
    public BindingsBuilder addMaybe(Variable key, Boolean value) {
        return this.addMaybe(key.getVarName(), value);
    }

    @Override
    public BindingsBuilder addMaybe(String key, Boolean value) {
        this.checkKeyNotPresent(key);
        if (value != null) {
            this.bindings.put(key, (Value)SimpleValueFactory.getInstance().createLiteral(value.booleanValue()));
        }
        return this;
    }

    @Override
    public BindingsBuilder add(Variable key, Float value) {
        return this.add(key.getVarName(), value);
    }

    @Override
    public BindingsBuilder add(String key, Float value) {
        Objects.requireNonNull(value);
        return this.addMaybe(key, value);
    }

    @Override
    public BindingsBuilder addMaybe(Variable key, Float value) {
        return this.addMaybe(key.getVarName(), value);
    }

    @Override
    public BindingsBuilder addMaybe(String key, Float value) {
        this.checkKeyNotPresent(key);
        if (value != null) {
            this.bindings.put(key, (Value)SimpleValueFactory.getInstance().createLiteral(value.floatValue()));
        }
        return this;
    }

    @Override
    public BindingsBuilder add(Variable key, Double value) {
        return this.add(key.getVarName(), value);
    }

    @Override
    public BindingsBuilder add(String key, Double value) {
        Objects.requireNonNull(value);
        return this.addMaybe(key, value);
    }

    @Override
    public BindingsBuilder addMaybe(Variable var, Double value) {
        return this.addMaybe(var.getVarName(), value);
    }

    @Override
    public BindingsBuilder addMaybe(String key, Double value) {
        this.checkKeyNotPresent(key);
        if (this.bindings != null) {
            this.bindings.put(key, (Value)SimpleValueFactory.getInstance().createLiteral(value.doubleValue()));
        }
        return this;
    }

    private void checkKeyNotPresent(String key) {
        if (this.bindings.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Binding for key '%s' already registered", key));
        }
    }
}

