/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.resultcache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class CachedGraphQueryResult
implements GraphQueryResult {
    private final List<Statement> statements;
    private Iterator<Statement> replayingIterator;
    private final Map<String, String> namespaces;

    CachedGraphQueryResult(List<Statement> statements, Map<String, String> namespaces) {
        this.statements = new ArrayList<Statement>(statements);
        this.namespaces = new HashMap<String, String>();
        this.namespaces.putAll(namespaces);
        this.replayingIterator = statements.iterator();
    }

    public Map<String, String> getNamespaces() throws QueryEvaluationException {
        return this.namespaces;
    }

    public Iterator<Statement> iterator() {
        return this.replayingIterator;
    }

    public void close() throws QueryEvaluationException {
        this.replayingIterator = null;
    }

    public boolean hasNext() throws QueryEvaluationException {
        return this.replayingIterator.hasNext();
    }

    public Statement next() throws QueryEvaluationException {
        return this.replayingIterator.next();
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    public Stream<Statement> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.replayingIterator, 16), false);
    }

    public void forEach(Consumer<? super Statement> action) {
        this.statements.forEach(action);
    }

    public Spliterator<Statement> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }
}

