/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.dao.exception;

import org.eclipse.rdf4j.spring.dao.exception.RDF4JDaoException;

public class IncorrectResultSetSizeException
extends RDF4JDaoException {
    int expectedSize;
    int actualSize;

    public IncorrectResultSetSizeException(int expectedSize, int actualSize) {
        super(IncorrectResultSetSizeException.makeMessage(expectedSize, actualSize));
        this.expectedSize = expectedSize;
        this.actualSize = actualSize;
    }

    private static String makeMessage(int expectedSize, int actualSize) {
        return String.format("Expected %d results but got %d", expectedSize, actualSize);
    }

    public IncorrectResultSetSizeException(String message, int expectedSize, int actualSize) {
        super(message);
        this.expectedSize = expectedSize;
        this.actualSize = actualSize;
    }

    public IncorrectResultSetSizeException(String message, Throwable cause, int expectedSize, int actualSize) {
        super(message, cause);
        this.expectedSize = expectedSize;
        this.actualSize = actualSize;
    }

    public IncorrectResultSetSizeException(Throwable cause, int expectedSize, int actualSize) {
        super(IncorrectResultSetSizeException.makeMessage(expectedSize, actualSize), cause);
        this.expectedSize = expectedSize;
        this.actualSize = actualSize;
    }

    public int getExpectedSize() {
        return this.expectedSize;
    }

    public int getActualSize() {
        return this.actualSize;
    }
}

