/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.util;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.spring.util.TypeMappingUtils;

public class ObjectMapUtils {
    public static IRI getIRI(Map<String, Object> map, String key) {
        return TypeMappingUtils.toIRI((String)map.get(key));
    }

    public static IRI getIRIMaybe(Map<String, Object> map, String key) {
        return TypeMappingUtils.toIRIMaybe((String)map.get(key));
    }

    public static Boolean getBoolean(Map<String, Object> map, String key) {
        return TypeMappingUtils.toBoolean((String)map.get(key));
    }

    public static Boolean getBooleanMaybe(Map<String, Object> map, String key) {
        return TypeMappingUtils.toBooleanMaybe((Boolean)map.get(key));
    }

    public static Optional<Boolean> getBooleanOptional(Map<String, Object> map, String key) {
        return TypeMappingUtils.toBooleanOptional((Boolean)map.get(key));
    }

    public static String getString(Map<String, Object> map, String key) {
        String value = (String)map.get(key);
        Objects.requireNonNull(value);
        return value;
    }

    public static String getStringMaybe(Map<String, Object> map, String key) {
        return (String)map.get(key);
    }

    public static Optional<String> getStringOptional(Map<String, Object> map, String key) {
        return Optional.ofNullable(ObjectMapUtils.getStringMaybe(map, key));
    }
}

