/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.dao.support.sparql;

import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import org.apache.commons.collections4.map.LRUMap;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedSparqlManager {
    private final LRUMap<String, Object> preparedSparqlMap = new LRUMap(500, 100);
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public <T> T get(String sparqlString, RepositoryConnection con, Function<String, T> preparer) {
        Object element;
        String key = sparqlString + "@con" + con.hashCode();
        this.logger.debug("obtaining prepared sparql operation...");
        long startGet = System.currentTimeMillis();
        Object preparedSparql = element = this.preparedSparqlMap.get((Object)key);
        if (preparedSparql == null) {
            this.logger.debug("\tnot found in prepared operation map, preparing new operation...");
            long start = System.currentTimeMillis();
            try {
                preparedSparql = preparer.apply(sparqlString);
            }
            catch (Exception e) {
                this.logger.debug("Error preparing the follwing query:\n{}", (Object)sparqlString);
                throw e;
            }
            long stop = System.currentTimeMillis();
            this.logger.debug("\tpreparing the operation took {} millis", (Object)(stop - start));
            this.preparedSparqlMap.put((Object)key, preparedSparql);
        }
        ((Operation)preparedSparql).clearBindings();
        long endGet = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("obtaining prepared sparql operation took {} millis", (Object)(endGet - startGet));
            this.logger.debug("sparql:\n{}", (Object)sparqlString);
        }
        return (T)preparedSparql;
    }
}

