/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.support;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.shacl.ShaclSailValidationException;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expressions;
import org.eclipse.rdf4j.sparqlbuilder.constraint.propertypath.PropertyPath;
import org.eclipse.rdf4j.sparqlbuilder.core.SparqlBuilder;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.sparqlbuilder.core.query.ModifyQuery;
import org.eclipse.rdf4j.sparqlbuilder.core.query.Queries;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfObject;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicate;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfValue;
import org.eclipse.rdf4j.spring.dao.exception.RDF4JDaoException;
import org.eclipse.rdf4j.spring.dao.support.UpdateWithModelBuilder;
import org.eclipse.rdf4j.spring.dao.support.opbuilder.GraphQueryEvaluationBuilder;
import org.eclipse.rdf4j.spring.dao.support.opbuilder.TupleQueryEvaluationBuilder;
import org.eclipse.rdf4j.spring.dao.support.opbuilder.UpdateExecutionBuilder;
import org.eclipse.rdf4j.spring.dao.support.sparql.NamedSparqlSupplier;
import org.eclipse.rdf4j.spring.support.DefaultUUIDSource;
import org.eclipse.rdf4j.spring.support.OperationInstantiator;
import org.eclipse.rdf4j.spring.support.UUIDSource;
import org.eclipse.rdf4j.spring.support.connectionfactory.RepositoryConnectionFactory;
import org.eclipse.rdf4j.spring.util.TypeMappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;

public class RDF4JTemplate {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private RepositoryConnectionFactory repositoryConnectionFactory;
    private OperationInstantiator operationInstantiator;
    private ResourceLoader resourceLoader;
    private UUIDSource uuidSource;

    public RDF4JTemplate(@Autowired RepositoryConnectionFactory repositoryConnectionFactory, @Autowired OperationInstantiator operationInstantiator, @Autowired ResourceLoader resourceLoader, @Autowired(required=false) UUIDSource uuidSource) {
        this.repositoryConnectionFactory = repositoryConnectionFactory;
        this.operationInstantiator = operationInstantiator;
        this.resourceLoader = resourceLoader;
        this.uuidSource = uuidSource == null ? new DefaultUUIDSource() : uuidSource;
    }

    public void consumeConnection(Consumer<RepositoryConnection> fun) {
        RepositoryConnection con = this.getRepositoryConnection();
        if (logger.isDebugEnabled()) {
            logger.debug("using connection {} of type {}", (Object)con.hashCode(), (Object)con.getClass().getSimpleName());
        }
        try {
            fun.accept(con);
        }
        catch (Exception e) {
            this.logIfShaclValidationFailure(e);
            throw e;
        }
    }

    public <T> T applyToConnection(Function<RepositoryConnection, T> fun) {
        RepositoryConnection con = this.getRepositoryConnection();
        if (logger.isDebugEnabled()) {
            logger.debug("using connection {} of type {}", (Object)con.hashCode(), (Object)con.getClass().getSimpleName());
        }
        try {
            return fun.apply(con);
        }
        catch (Exception e) {
            this.logIfShaclValidationFailure(e);
            throw e;
        }
    }

    public UpdateExecutionBuilder update(String updateString) {
        return this.applyToConnection(con -> new UpdateExecutionBuilder(this.operationInstantiator.getUpdate((RepositoryConnection)con, updateString), this));
    }

    public UpdateExecutionBuilder update(Class<?> owner, String operationName, Supplier<String> updateStringSupplier) {
        return this.applyToConnection(con -> new UpdateExecutionBuilder(this.operationInstantiator.getUpdate((RepositoryConnection)con, owner, operationName, updateStringSupplier), this));
    }

    public UpdateExecutionBuilder updateFromResource(Class<?> owner, String resourceName) {
        return this.update(owner, resourceName, () -> this.getStringSupplierFromResourceContent(resourceName).get());
    }

    public UpdateExecutionBuilder update(Class<?> owner, NamedSparqlSupplier namedSparqlSupplier) {
        return this.update(owner, namedSparqlSupplier.getName(), namedSparqlSupplier.getSparqlSupplier());
    }

    public UpdateExecutionBuilder updateWithoutCachingStatement(String updateString) {
        return this.applyToConnection(con -> new UpdateExecutionBuilder(con.prepareUpdate(updateString), this));
    }

    public UpdateWithModelBuilder updateWithBuilder() {
        return new UpdateWithModelBuilder(this.getRepositoryConnection());
    }

    public TupleQueryEvaluationBuilder tupleQuery(String queryString) {
        return new TupleQueryEvaluationBuilder(this.applyToConnection(con -> this.operationInstantiator.getTupleQuery((RepositoryConnection)con, queryString)), this);
    }

    public TupleQueryEvaluationBuilder tupleQuery(Class<?> owner, String operationName, Supplier<String> queryStringSupplier) {
        return new TupleQueryEvaluationBuilder(this.applyToConnection(con -> this.operationInstantiator.getTupleQuery((RepositoryConnection)con, owner, operationName, queryStringSupplier)), this);
    }

    public TupleQueryEvaluationBuilder tupleQueryFromResource(Class<?> owner, String resourceName) {
        return this.tupleQuery(owner, resourceName, () -> this.getStringSupplierFromResourceContent(resourceName).get());
    }

    public TupleQueryEvaluationBuilder tupleQuery(Class<?> owner, NamedSparqlSupplier namedSparqlSupplier) {
        return this.tupleQuery(owner, namedSparqlSupplier.getName(), namedSparqlSupplier.getSparqlSupplier());
    }

    public GraphQueryEvaluationBuilder graphQuery(String graphQueryString) {
        return new GraphQueryEvaluationBuilder(this.applyToConnection(con -> this.operationInstantiator.getGraphQuery((RepositoryConnection)con, graphQueryString)), this);
    }

    public GraphQueryEvaluationBuilder graphQuery(Class<?> owner, String operationName, Supplier<String> queryStringSupplier) {
        return new GraphQueryEvaluationBuilder(this.applyToConnection(con -> this.operationInstantiator.getGraphQuery((RepositoryConnection)con, owner, operationName, queryStringSupplier)), this);
    }

    public GraphQueryEvaluationBuilder graphQueryFromResource(Class<?> owner, String resourceName) {
        return this.graphQuery(owner, resourceName, () -> this.getStringSupplierFromResourceContent(resourceName).get());
    }

    public GraphQueryEvaluationBuilder graphQuery(Class<?> owner, NamedSparqlSupplier namedSparqlSupplier) {
        return this.graphQuery(owner, namedSparqlSupplier.getName(), namedSparqlSupplier.getSparqlSupplier());
    }

    public void deleteTriplesWithSubject(IRI id) {
        this.consumeConnection(con -> con.remove((Resource)id, null, null, new Resource[0]));
    }

    public void delete(IRI id) {
        this.consumeConnection(con -> {
            con.remove((Resource)id, null, null, new Resource[0]);
            con.remove((Resource)null, null, (Value)id, new Resource[0]);
        });
    }

    public void delete(IRI start, List<PropertyPath> propertyPaths) {
        ArrayList targets = new ArrayList();
        int i = 0;
        Variable sp = SparqlBuilder.var((String)"sp");
        Variable so = SparqlBuilder.var((String)"so");
        Variable is = SparqlBuilder.var((String)"is");
        Variable ip = SparqlBuilder.var((String)"ip");
        ModifyQuery q = Queries.MODIFY().delete(new TriplePattern[]{TypeMappingUtils.toIri(start).has((RdfPredicate)sp, new RdfObject[]{so}), is.has((RdfPredicate)ip, new Value[]{start})}).where(new GraphPattern[]{TypeMappingUtils.toIri(start).has((RdfPredicate)sp, new RdfObject[]{so}).optional(), is.has((RdfPredicate)ip, new Value[]{start}).optional()});
        for (PropertyPath p : propertyPaths) {
            Variable target = SparqlBuilder.var((String)("target_" + ++i));
            Variable p1 = SparqlBuilder.var((String)("p1_" + i));
            Variable o1 = SparqlBuilder.var((String)("o2_" + i));
            Variable p2 = SparqlBuilder.var((String)("p2_" + i));
            Variable s2 = SparqlBuilder.var((String)("s2_" + i));
            q.delete(new TriplePattern[]{target.has((RdfPredicate)p1, new RdfObject[]{o1}), s2.has((RdfPredicate)p2, new RdfObject[]{target})}).where(new GraphPattern[]{TypeMappingUtils.toIri(start).has((RdfPredicate)p, new RdfObject[]{target}).optional(), target.has((RdfPredicate)p1, new RdfObject[]{o1}).optional(), s2.has((RdfPredicate)p2, new RdfObject[]{target}).optional()});
        }
        this.update(q.getQueryString()).execute();
    }

    public void associate(IRI fromResource, IRI property, Collection<IRI> toResources, boolean deleteOtherOutgoing, boolean deleteOtherIcoming) {
        String query;
        Variable from = SparqlBuilder.var((String)"fromResource");
        Variable to = SparqlBuilder.var((String)"toResource");
        if (deleteOtherOutgoing) {
            query = Queries.MODIFY().delete(new TriplePattern[]{from.has(property, new RdfObject[]{to})}).where(new GraphPattern[]{from.has(property, new RdfObject[]{to})}).getQueryString();
            ((UpdateExecutionBuilder)this.update(query).withBinding(from, fromResource)).execute();
        }
        if (deleteOtherIcoming) {
            query = Queries.MODIFY().delete(new TriplePattern[]{from.has(property, new RdfObject[]{to})}).where(new GraphPattern[]{from.has(property, new RdfObject[]{to}).filter(Expressions.in((Variable)to, (RdfValue[])toResources.stream().map(TypeMappingUtils::toIri).collect(Collectors.toList()).toArray(new RdfValue[toResources.size()])))}).getQueryString();
            this.update(query).execute();
        }
        query = Queries.INSERT_DATA((TriplePattern[])toResources.stream().map(e -> TypeMappingUtils.toIri(fromResource).has(property, new Value[]{e})).collect(Collectors.toList()).toArray(new TriplePattern[toResources.size()])).getQueryString();
        this.updateWithoutCachingStatement(query).execute();
    }

    public Supplier<String> getStringSupplierFromResourceContent(String resourceName) {
        Objects.requireNonNull(resourceName);
        try {
            org.springframework.core.io.Resource res = this.resourceLoader.getResource(resourceName);
            String contentAsString = new String(res.getInputStream().readAllBytes());
            return () -> contentAsString;
        }
        catch (IOException e) {
            throw new RDF4JDaoException(String.format("Cannot read String from resource %s", resourceName));
        }
    }

    private RepositoryConnection getRepositoryConnection() {
        return this.repositoryConnectionFactory.getConnection();
    }

    private void logIfShaclValidationFailure(Throwable t) {
        Throwable cause = t.getCause();
        if (cause instanceof ShaclSailValidationException) {
            logger.error("SHACL Validation failed!");
            Model report = ((ShaclSailValidationException)cause).validationReportAsModel();
            StringWriter out = new StringWriter();
            Rio.write((Iterable)report, (Writer)out, (RDFFormat)RDFFormat.TURTLE);
            logger.error("Validation report:\n{}", (Object)out.toString());
        }
    }

    public IRI getNewUUID() {
        return this.uuidSource.nextUUID();
    }
}

