/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.resultcache;

import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.spring.resultcache.ResultCache;
import org.eclipse.rdf4j.spring.resultcache.ResultCacheProperties;
import org.eclipse.rdf4j.spring.resultcache.ReusableTupleQueryResult;
import org.eclipse.rdf4j.spring.support.query.DelegatingTupleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultCachingTupleQuery
extends DelegatingTupleQuery {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private WeakReference<ResultCache<Integer, ReusableTupleQueryResult>> localResultCacheRef;
    private ResultCache<Integer, ReusableTupleQueryResult> globalResultCache;
    private ResultCacheProperties properties;

    public ResultCachingTupleQuery(TupleQuery delegate, ResultCache<Integer, ReusableTupleQueryResult> localResultCache, ResultCache<Integer, ReusableTupleQueryResult> globalResultCache, ResultCacheProperties properties) {
        super(delegate);
        this.localResultCacheRef = new WeakReference<ResultCache<Integer, ReusableTupleQueryResult>>(localResultCache);
        this.globalResultCache = globalResultCache;
        this.properties = properties;
    }

    public void renewLocalResultCache(ResultCache<Integer, ReusableTupleQueryResult> localResultCache) {
        if (logger.isDebugEnabled()) {
            ResultCache previousCache = (ResultCache)this.localResultCacheRef.get();
            logger.debug("resetting local result cache to {} (was: {})", (Object)localResultCache.hashCode(), previousCache != null ? Integer.valueOf(previousCache.hashCode()) : "null");
        }
        this.localResultCacheRef = new WeakReference<ResultCache<Integer, ReusableTupleQueryResult>>(localResultCache);
    }

    @Override
    public TupleQueryResult evaluate() throws QueryEvaluationException {
        TupleQueryResult cachedResult;
        BindingSet currentBindings = this.getDelegate().getBindings();
        Integer cacheKey = currentBindings.hashCode() + this.getDelegate().toString().hashCode();
        logger.debug("Checking global result cache");
        if (this.properties.isAssumeNoOtherRepositoryClients() && (cachedResult = this.recreateCachedResultIfPossible(this.globalResultCache, currentBindings, cacheKey)) != null) {
            return cachedResult;
        }
        logger.debug("Checking local result cache");
        ResultCache localResultCache = (ResultCache)this.localResultCacheRef.get();
        if (localResultCache != null && (cachedResult = this.recreateCachedResultIfPossible(localResultCache, currentBindings, cacheKey)) != null) {
            return cachedResult;
        }
        logger.debug("No reusable cached result found, executing query");
        TupleQueryResult delegateResult = this.getDelegate().evaluate();
        if (delegateResult instanceof ReusableTupleQueryResult) {
            throw new IllegalStateException("Cannot cache an already cached result! This should not happen, the caching layer seems misconfigured.");
        }
        ReusableTupleQueryResult cacheableResult = new ReusableTupleQueryResult(delegateResult, currentBindings);
        if (localResultCache != null) {
            localResultCache.put(cacheKey, cacheableResult);
        }
        if (this.properties.isAssumeNoOtherRepositoryClients()) {
            this.globalResultCache.put(cacheKey, cacheableResult);
        }
        return cacheableResult;
    }

    private TupleQueryResult recreateCachedResultIfPossible(ResultCache<Integer, ReusableTupleQueryResult> cache, BindingSet currentBindings, Integer cacheKey) {
        ReusableTupleQueryResult result = cache.get(cacheKey);
        if (result != null && result.queryBindingsAreIdentical(currentBindings) && result.canReuse()) {
            logger.debug("Reusing cached result");
            return result.recreateTupleQueryResult();
        }
        return null;
    }

    @Override
    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        TupleQueryResult queryResult = this.evaluate();
        QueryResults.report((TupleQueryResult)queryResult, (QueryResultHandler)handler);
    }
}

