/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.resultcache;

import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.spring.resultcache.ResultCache;
import org.eclipse.rdf4j.spring.resultcache.ResultCacheProperties;
import org.eclipse.rdf4j.spring.resultcache.ReusableGraphQueryResult;
import org.eclipse.rdf4j.spring.support.query.DelegatingGraphQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultCachingGraphQuery
extends DelegatingGraphQuery {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private WeakReference<ResultCache<Integer, ReusableGraphQueryResult>> localResultCacheRef;
    private ResultCache<Integer, ReusableGraphQueryResult> globalResultCache;
    private ResultCacheProperties properties;

    public ResultCachingGraphQuery(GraphQuery delegate, ResultCache<Integer, ReusableGraphQueryResult> localResultCache, ResultCache<Integer, ReusableGraphQueryResult> globalResultCache, ResultCacheProperties properties) {
        super(delegate);
        this.localResultCacheRef = new WeakReference<ResultCache<Integer, ReusableGraphQueryResult>>(localResultCache);
        this.globalResultCache = globalResultCache;
        this.properties = properties;
    }

    public void renewLocalResultCache(ResultCache<Integer, ReusableGraphQueryResult> localGraphQueryResultCache) {
        if (logger.isDebugEnabled()) {
            ResultCache previousCache = (ResultCache)this.localResultCacheRef.get();
            logger.debug("resetting local result cache to {} (was: {})", (Object)localGraphQueryResultCache.hashCode(), previousCache != null ? Integer.valueOf(previousCache.hashCode()) : "null");
        }
        this.localResultCacheRef = new WeakReference<ResultCache<Integer, ReusableGraphQueryResult>>(localGraphQueryResultCache);
    }

    @Override
    public GraphQueryResult evaluate() throws QueryEvaluationException {
        GraphQueryResult cachedResult;
        BindingSet currentBindings = this.getDelegate().getBindings();
        Integer cacheKey = currentBindings.hashCode() + this.getDelegate().toString().hashCode();
        logger.debug("Checking global result cache");
        if (this.properties.isAssumeNoOtherRepositoryClients() && (cachedResult = this.recreateCachedResultIfPossible(currentBindings, cacheKey, this.globalResultCache)) != null) {
            return cachedResult;
        }
        logger.debug("Checking local result cache");
        ResultCache localResultCache = (ResultCache)this.localResultCacheRef.get();
        if (localResultCache != null && (cachedResult = this.recreateCachedResultIfPossible(currentBindings, cacheKey, localResultCache)) != null) {
            return cachedResult;
        }
        logger.debug("No reusable cached result found, executing query");
        GraphQueryResult delegateResult = this.getDelegate().evaluate();
        if (delegateResult instanceof ReusableGraphQueryResult) {
            throw new IllegalStateException("Cannot cache an already cached result! This should not happen, the caching layer seems misconfigured.");
        }
        ReusableGraphQueryResult cacheableResult = new ReusableGraphQueryResult(delegateResult, currentBindings);
        if (localResultCache != null) {
            localResultCache.put(cacheKey, cacheableResult);
        }
        return cacheableResult;
    }

    private GraphQueryResult recreateCachedResultIfPossible(BindingSet currentBindings, Integer cacheKey, ResultCache<Integer, ReusableGraphQueryResult> cache) {
        ReusableGraphQueryResult result = cache.get(cacheKey);
        if (result != null && result.queryBindingsAreIdentical(currentBindings) && result.canReuse()) {
            logger.debug("Reusing previously calculated result");
            return result.recreateGraphQueryResult();
        }
        return null;
    }
}

