/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.resultcache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.RepositoryConnectionWrapper;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.spring.resultcache.Clearable;
import org.eclipse.rdf4j.spring.resultcache.ClearableAwareUpdate;
import org.eclipse.rdf4j.spring.resultcache.LRUResultCache;
import org.eclipse.rdf4j.spring.resultcache.ResultCacheProperties;
import org.eclipse.rdf4j.spring.resultcache.ResultCachingGraphQuery;
import org.eclipse.rdf4j.spring.resultcache.ResultCachingTupleQuery;
import org.eclipse.rdf4j.spring.resultcache.ReusableGraphQueryResult;
import org.eclipse.rdf4j.spring.resultcache.ReusableTupleQueryResult;

public class CachingRepositoryConnection
extends RepositoryConnectionWrapper
implements Clearable {
    private LRUResultCache<ReusableTupleQueryResult> localTupleQueryResultCache;
    private LRUResultCache<ReusableGraphQueryResult> localGraphQueryResultCache;
    private LRUResultCache<ReusableTupleQueryResult> globalTupleQueryResultCache;
    private LRUResultCache<ReusableGraphQueryResult> globalGraphQueryResultCache;
    private ResultCacheProperties properties;
    private boolean clearGlobalResultCacheOnClose = false;

    public CachingRepositoryConnection(RepositoryConnection delegate, LRUResultCache<ReusableTupleQueryResult> globalTupleQueryResultCache, LRUResultCache<ReusableGraphQueryResult> globalGraphQueryResultCache, ResultCacheProperties properties) {
        super(delegate.getRepository(), delegate);
        this.globalGraphQueryResultCache = globalGraphQueryResultCache;
        this.globalTupleQueryResultCache = globalTupleQueryResultCache;
        this.localGraphQueryResultCache = new LRUResultCache(properties);
        this.localTupleQueryResultCache = new LRUResultCache(properties);
        this.properties = properties;
    }

    private Integer makeCacheKey(QueryLanguage ql, String query, String baseURI) {
        return (ql.toString() + query + baseURI).hashCode();
    }

    public void renewLocalResultCache(ResultCachingTupleQuery resultCachingTupleQuery) {
        resultCachingTupleQuery.renewLocalResultCache(this.localTupleQueryResultCache);
    }

    public void renewLocalResultCache(ResultCachingGraphQuery resultCachingGraphQuery) {
        resultCachingGraphQuery.renewLocalResultCache(this.localGraphQueryResultCache);
    }

    public void renewClearable(ClearableAwareUpdate update) {
        update.renewClearable(this);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException, RepositoryException {
        return new ResultCachingTupleQuery(this.getDelegate().prepareTupleQuery(ql, queryString, baseURI), this.localTupleQueryResultCache, this.globalTupleQueryResultCache, this.properties);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException, RepositoryException {
        return new ResultCachingGraphQuery(this.getDelegate().prepareGraphQuery(ql, queryString, baseURI), this.localGraphQueryResultCache, this.globalGraphQueryResultCache, this.properties);
    }

    public Update prepareUpdate(QueryLanguage ql, String updateString, String baseURI) throws MalformedQueryException, RepositoryException {
        return new ClearableAwareUpdate(this.getDelegate().prepareUpdate(ql, updateString, baseURI), this);
    }

    public void close() throws RepositoryException {
        this.localGraphQueryResultCache.markDirty();
        this.localTupleQueryResultCache.markDirty();
        if (this.clearGlobalResultCacheOnClose) {
            this.globalGraphQueryResultCache.markDirty();
            this.globalTupleQueryResultCache.markDirty();
        }
        super.close();
    }

    @Override
    public void markDirty() {
        this.localGraphQueryResultCache.markDirty();
        this.localTupleQueryResultCache.markDirty();
        this.globalTupleQueryResultCache.bypassForCurrentThread();
        this.globalGraphQueryResultCache.bypassForCurrentThread();
        this.clearGlobalResultCacheOnClose = true;
    }

    @Override
    public void clearCachedResults() {
        this.localGraphQueryResultCache.clearCachedResults();
        this.localTupleQueryResultCache.clearCachedResults();
    }

    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        super.add(file, baseURI, dataFormat, contexts);
        this.markDirty();
    }

    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        super.add(in, baseURI, dataFormat, contexts);
        this.markDirty();
    }

    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        super.add(statements, contexts);
        this.markDirty();
    }

    public <E extends Exception> void add(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        super.add(statementIter, contexts);
        this.markDirty();
    }

    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        super.add(reader, baseURI, dataFormat, contexts);
        this.markDirty();
    }

    public void add(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        super.add(subject, predicate, object, contexts);
        this.markDirty();
    }

    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        super.add(st, contexts);
        this.markDirty();
    }

    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        super.add(url, baseURI, dataFormat, contexts);
        this.markDirty();
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        super.clear(contexts);
        this.markDirty();
    }

    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        super.remove(statements, contexts);
        this.markDirty();
    }

    public <E extends Exception> void remove(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        super.remove(statementIter, contexts);
        this.markDirty();
    }

    public void remove(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        super.remove(subject, predicate, object, contexts);
        this.markDirty();
    }

    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        super.remove(st, contexts);
        this.markDirty();
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        super.removeNamespace(prefix);
        this.markDirty();
    }
}

