/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.resultcache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;

public class CachedTupleQueryResult
implements TupleQueryResult {
    private List<BindingSet> bindingSets;
    private Iterator<BindingSet> replayingIterator;
    private List<String> bindingNames;

    CachedTupleQueryResult(List<BindingSet> bindingSets, List<String> bindingNames) {
        this.bindingSets = new LinkedList<BindingSet>(bindingSets);
        this.bindingNames = new ArrayList<String>(bindingNames);
        this.replayingIterator = bindingSets.iterator();
    }

    public List<String> getBindingNames() throws QueryEvaluationException {
        return this.bindingNames;
    }

    public Iterator<BindingSet> iterator() {
        return this.replayingIterator;
    }

    public void close() throws QueryEvaluationException {
        this.replayingIterator = null;
    }

    public boolean hasNext() throws QueryEvaluationException {
        return this.replayingIterator.hasNext();
    }

    public BindingSet next() throws QueryEvaluationException {
        return this.replayingIterator.next();
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    public Stream<BindingSet> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.replayingIterator, 16), false);
    }

    public void forEach(Consumer<? super BindingSet> action) {
        this.bindingSets.forEach(action);
    }

    public Spliterator<BindingSet> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }
}

