/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.resultcache;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.spring.resultcache.CachedGraphQueryResult;
import org.eclipse.rdf4j.spring.resultcache.ThrowableRecorder;
import org.eclipse.rdf4j.spring.support.query.DelegatingIterator;

public class ReusableGraphQueryResult
implements GraphQueryResult,
ThrowableRecorder {
    private GraphQueryResult originalResult;
    private List<Statement> statements;
    private AtomicBoolean recording = new AtomicBoolean(true);
    private AtomicBoolean exceptionDuringRecording = new AtomicBoolean(false);
    private BindingSet queryBindings;
    private Map<String, String> namespaces;

    public ReusableGraphQueryResult(GraphQueryResult result, BindingSet queryBindings) {
        this.originalResult = result;
        this.queryBindings = queryBindings;
        this.statements = new LinkedList<Statement>();
        this.recording.set(true);
        this.exceptionDuringRecording.set(false);
    }

    public boolean queryBindingsAreIdentical(BindingSet candidate) {
        return this.queryBindings.equals((Object)candidate);
    }

    public boolean canReuse() {
        return !this.recording.get() && this.originalResult == null && !this.exceptionDuringRecording.get();
    }

    public CachedGraphQueryResult recreateGraphQueryResult() {
        if (this.recording.get()) {
            throw new IllegalStateException("Cannot reuse yet: still recording");
        }
        return new CachedGraphQueryResult(this.statements, this.namespaces);
    }

    @Override
    public void recordThrowable(Throwable t) {
        if (this.recording.get()) {
            this.exceptionDuringRecording.set(true);
        }
    }

    public Map<String, String> getNamespaces() throws QueryEvaluationException {
        if (this.recording.get()) {
            return this.originalResult.getNamespaces();
        }
        throw new IllegalStateException("Not open");
    }

    public Iterator<Statement> iterator() {
        if (this.recording.get()) {
            return ThrowableRecorder.recordingThrowable(() -> new DelegatingIterator<Statement>(this.originalResult.iterator()){

                @Override
                public Statement next() {
                    Statement n = (Statement)super.next();
                    ReusableGraphQueryResult.this.statements.add(n);
                    return n;
                }
            }, (ThrowableRecorder)this);
        }
        throw new IllegalStateException("Not open");
    }

    public void close() throws QueryEvaluationException {
        if (!this.recording.get()) {
            throw new IllegalStateException("Cannot close: not open");
        }
        ThrowableRecorder.recordingThrowable(() -> {
            while (this.hasNext()) {
                this.next();
            }
            try {
                this.namespaces = this.originalResult.getNamespaces();
                this.originalResult.close();
            }
            finally {
                this.originalResult = null;
                this.recording.set(false);
            }
        }, (ThrowableRecorder)this);
    }

    public boolean hasNext() throws QueryEvaluationException {
        if (this.recording.get()) {
            return ThrowableRecorder.recordingThrowable(() -> this.originalResult.hasNext(), (ThrowableRecorder)this);
        }
        return false;
    }

    public Statement next() throws QueryEvaluationException {
        if (this.recording.get()) {
            Statement n = ThrowableRecorder.recordingThrowable(() -> (Statement)this.originalResult.next(), (ThrowableRecorder)this);
            this.statements.add(n);
            return n;
        }
        throw new IllegalStateException("Not open");
    }

    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    public Stream<Statement> stream() {
        if (this.recording.get()) {
            return ThrowableRecorder.recordingThrowable(() -> this.originalResult.stream().map(bindings -> {
                this.statements.add((Statement)bindings);
                return bindings;
            }), (ThrowableRecorder)this);
        }
        throw new IllegalStateException("Not open");
    }

    public void forEach(Consumer<? super Statement> action) {
        if (!this.recording.get()) {
            throw new IllegalStateException("Not open");
        }
        ThrowableRecorder.recordingThrowable(() -> this.originalResult.forEach(bindings -> {
            this.statements.add((Statement)bindings);
            action.accept((Statement)bindings);
        }), (ThrowableRecorder)this);
    }

    public Spliterator<Statement> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }
}

