/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.pool;

import java.lang.invoke.MethodHandles;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.spring.pool.PooledRepositoryConnection;
import org.eclipse.rdf4j.spring.support.connectionfactory.RepositoryConnectionFactory;
import org.eclipse.rdf4j.spring.tx.exception.RepositoryConnectionPoolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PooledConnectionObjectFactory
extends BasePooledObjectFactory<RepositoryConnection> {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ObjectPool<RepositoryConnection> pool;
    private RepositoryConnectionFactory delegate;

    public PooledConnectionObjectFactory(RepositoryConnectionFactory delegate) {
        this.delegate = delegate;
    }

    public RepositoryConnection create() throws Exception {
        this.logger.debug("Creating pooled connection - obtaining underlying connection from delegate factory");
        try {
            return this.delegate.getConnection();
        }
        catch (Exception e) {
            throw new RepositoryConnectionPoolException("Error obtaining RepositoryConnection for pool", e);
        }
    }

    public PooledObject<RepositoryConnection> wrap(RepositoryConnection con) {
        return new DefaultPooledObject((Object)new PooledRepositoryConnection(con, this.pool));
    }

    public void setPool(ObjectPool<RepositoryConnection> pool) {
        this.pool = pool;
    }

    public void destroyObject(PooledObject<RepositoryConnection> pooledObject) throws Exception {
        this.logger.debug("destroying pooled connection - closing underlying connection");
        try {
            ((RepositoryConnection)pooledObject.getObject()).close();
            this.logger.debug("successfully closed underlying connection");
        }
        catch (Exception e) {
            throw new RepositoryConnectionPoolException("Error closing RepositoryConnection", e);
        }
    }

    public boolean validateObject(PooledObject<RepositoryConnection> p) {
        RepositoryConnection con = (RepositoryConnection)p.getObject();
        try {
            con.prepareTupleQuery("select (1 as ?one) where {}").evaluate().close();
        }
        catch (Exception e) {
            this.logger.info("Test query on pooled connection caused exception - it will be destroyed");
            return false;
        }
        this.logger.debug("pooled connection still works");
        return true;
    }
}

