/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.dao.support.operation;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.spring.dao.exception.mapper.ExceptionMapper;
import org.eclipse.rdf4j.spring.dao.support.operation.OperationUtils;
import org.eclipse.rdf4j.spring.dao.support.operation.TupleQueryResultConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleQueryEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TupleQuery query;
    private Map<String, Value> bindings;

    private TupleQueryEvaluator(TupleQuery query) {
        this.query = query;
        this.bindings = null;
    }

    private TupleQueryEvaluator(TupleQuery query, Map<String, Value> bindings) {
        Objects.requireNonNull(query);
        Objects.requireNonNull(bindings);
        this.query = query;
        this.bindings = bindings;
    }

    public static TupleQueryEvaluator of(TupleQuery query, Map<String, Value> bindings) {
        return new TupleQueryEvaluator(query, bindings);
    }

    public static TupleQueryEvaluator of(TupleQuery query) {
        return new TupleQueryEvaluator(query);
    }

    public TupleQueryResultConverter execute() {
        try {
            if (this.bindings != null) {
                OperationUtils.setBindings((Operation)this.query, this.bindings);
            }
            return new TupleQueryResultConverter(this.query.evaluate());
        }
        catch (Exception e) {
            logger.debug("Caught execption while evaluating TupleQuery", (Throwable)e);
            throw ExceptionMapper.mapException("Error evaluating TupleQuery", e);
        }
    }
}

