/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.dao;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.rdf4j.spring.dao.exception.RDF4JDaoException;
import org.eclipse.rdf4j.spring.dao.support.opbuilder.GraphQueryEvaluationBuilder;
import org.eclipse.rdf4j.spring.dao.support.opbuilder.TupleQueryEvaluationBuilder;
import org.eclipse.rdf4j.spring.dao.support.opbuilder.UpdateExecutionBuilder;
import org.eclipse.rdf4j.spring.dao.support.sparql.NamedSparqlSupplier;
import org.eclipse.rdf4j.spring.support.RDF4JTemplate;

public abstract class RDF4JDao {
    private final RDF4JTemplate rdf4JTemplate;
    private Map<String, NamedSparqlSupplier> namedSparqlSuppliers = new ConcurrentHashMap<String, NamedSparqlSupplier>();

    public RDF4JDao(RDF4JTemplate rdf4JTemplate) {
        this.rdf4JTemplate = rdf4JTemplate;
        this.prepareNamedSparqlSuppliers(new NamedSparqlSupplierPreparer());
    }

    protected RDF4JTemplate getRdf4JTemplate() {
        return this.rdf4JTemplate;
    }

    protected abstract NamedSparqlSupplierPreparer prepareNamedSparqlSuppliers(NamedSparqlSupplierPreparer var1);

    private void prepareNamedSparqlSupplier(String key, String sparql) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(sparql);
        this.namedSparqlSuppliers.put(key, new NamedSparqlSupplier(key, () -> sparql));
    }

    private void prepareNamedSparqlSupplierFromResource(String key, String resourceName) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(resourceName);
        String sparqlString = this.getRdf4JTemplate().getStringSupplierFromResourceContent(resourceName).get();
        this.namedSparqlSuppliers.put(key, new NamedSparqlSupplier(key, () -> sparqlString));
    }

    protected NamedSparqlSupplier getNamedSparqlSupplier(String key) {
        Objects.requireNonNull(key);
        NamedSparqlSupplier supplier = this.namedSparqlSuppliers.get(key);
        if (supplier == null) {
            throw new RDF4JDaoException(String.format("No NamedSparqlOperation found for key %s. Prepare it using Rdf4JDao.prepareNamedSparqlSuppliers() before calling this method!", key));
        }
        return supplier;
    }

    protected String getNamedSparqlString(String key) {
        return this.getNamedSparqlSupplier(key).getSparqlSupplier().get();
    }

    protected TupleQueryEvaluationBuilder getNamedTupleQuery(String key) {
        return this.getRdf4JTemplate().tupleQuery(this.getClass(), this.getNamedSparqlSupplier(key));
    }

    protected GraphQueryEvaluationBuilder getNamedGraphQuery(String key) {
        return this.getRdf4JTemplate().graphQuery(this.getClass(), this.getNamedSparqlSupplier(key));
    }

    protected UpdateExecutionBuilder getNamedUpdate(String key) {
        return this.getRdf4JTemplate().update(this.getClass(), this.getNamedSparqlSupplier(key));
    }

    public class NamedSparqlSupplierFinishBuilder {
        private String key;

        public NamedSparqlSupplierFinishBuilder(String key) {
            this.key = key;
        }

        public NamedSparqlSupplierPreparer supplySparql(String sparql) {
            RDF4JDao.this.prepareNamedSparqlSupplier(this.key, sparql);
            return new NamedSparqlSupplierPreparer();
        }

        public NamedSparqlSupplierPreparer supplySparqlFromResource(String resource) {
            RDF4JDao.this.prepareNamedSparqlSupplierFromResource(this.key, resource);
            return new NamedSparqlSupplierPreparer();
        }
    }

    public class NamedSparqlSupplierPreparer {
        private NamedSparqlSupplierPreparer() {
        }

        public NamedSparqlSupplierFinishBuilder forKey(String key) {
            return new NamedSparqlSupplierFinishBuilder(key);
        }
    }
}

