/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.pool;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.apache.commons.pool2.ObjectPool;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.RepositoryConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledRepositoryConnection
extends RepositoryConnectionWrapper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private RepositoryConnection delegate;
    private ObjectPool<RepositoryConnection> pool;

    public PooledRepositoryConnection(RepositoryConnection delegate, ObjectPool<RepositoryConnection> pool) {
        super(delegate.getRepository(), delegate);
        Objects.requireNonNull(delegate);
        Objects.requireNonNull(pool);
        this.delegate = delegate;
        this.pool = pool;
    }

    public void close() throws RepositoryException {
        logger.debug("Close called on pooled RepositoryConnection, returning it to pool");
        try {
            this.pool.returnObject((Object)this);
        }
        catch (Exception e) {
            throw new RepositoryException("Error returning connection to pool", (Throwable)e);
        }
    }
}

