/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.operationcache;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import org.apache.commons.collections4.map.LRUMap;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.spring.resultcache.CachingRepositoryConnection;
import org.eclipse.rdf4j.spring.resultcache.ClearableAwareUpdate;
import org.eclipse.rdf4j.spring.resultcache.ResultCachingGraphQuery;
import org.eclipse.rdf4j.spring.resultcache.ResultCachingTupleQuery;
import org.eclipse.rdf4j.spring.support.DirectOperationInstantiator;
import org.eclipse.rdf4j.spring.util.RepositoryConnectionWrappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingOperationInstantiator
extends DirectOperationInstantiator {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<RepositoryConnection, Map<String, Operation>> cachedOperations = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public TupleQuery getTupleQuery(RepositoryConnection con, Class<?> owner, String operationName, Supplier<String> tupleQueryStringSupplier) {
        return this.cachedOrNewOp(TupleQuery.class, con, owner, operationName, () -> this.getTupleQuery(con, (String)tupleQueryStringSupplier.get()));
    }

    @Override
    public Update getUpdate(RepositoryConnection con, Class<?> owner, String operationName, Supplier<String> updateStringSupplier) {
        return this.cachedOrNewOp(Update.class, con, owner, operationName, () -> this.getUpdate(con, (String)updateStringSupplier.get()));
    }

    @Override
    public GraphQuery getGraphQuery(RepositoryConnection con, Class<?> owner, String operationName, Supplier<String> graphQueryStringSupplier) {
        return this.cachedOrNewOp(GraphQuery.class, con, owner, operationName, () -> this.getGraphQuery(con, (String)graphQueryStringSupplier.get()));
    }

    private <T extends Operation> T cachedOrNewOp(Class<T> type, RepositoryConnection con, Class<?> owner, String operationName, Supplier<Operation> operationSupplier) {
        Operation op;
        RepositoryConnection rootConnection;
        LRUMap cachedOperationsForConnection;
        String key = this.makeOperationCacheKey(type, owner, operationName);
        if (logger.isDebugEnabled()) {
            logger.debug("Obtaining operation of type {} for owner {} with name {}", new Object[]{type.getSimpleName(), owner, operationName});
        }
        if ((cachedOperationsForConnection = this.cachedOperations.get(rootConnection = RepositoryConnectionWrappingUtils.findRoot(con))) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("No operations cached with connection yet, initializing operation cache for connection {}", (Object)rootConnection.hashCode());
            }
            cachedOperationsForConnection = new LRUMap(200, 10);
            this.cachedOperations.put(rootConnection, (Map<String, Operation>)cachedOperationsForConnection);
        }
        if ((op = cachedOperationsForConnection.get(key)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Instantiating operation and caching for future reuse");
            }
            op = operationSupplier.get();
            cachedOperationsForConnection.put(key, op);
        } else {
            this.renewLocalCacheIfPossible(op, con);
            if (logger.isDebugEnabled()) {
                logger.debug("Reusing cached operation");
            }
        }
        return (T)op;
    }

    private void renewLocalCacheIfPossible(Operation op, RepositoryConnection con) {
        if (con instanceof CachingRepositoryConnection) {
            if (op instanceof ResultCachingGraphQuery) {
                ((CachingRepositoryConnection)con).renewLocalResultCache((ResultCachingGraphQuery)op);
            } else if (op instanceof ResultCachingTupleQuery) {
                ((CachingRepositoryConnection)con).renewLocalResultCache((ResultCachingTupleQuery)op);
            } else if (op instanceof ClearableAwareUpdate) {
                ((ClearableAwareUpdate)op).renewClearable((CachingRepositoryConnection)con);
            }
        }
    }

    private <T extends Operation> String makeOperationCacheKey(Class<T> operationType, Class<?> owner, String name) {
        return operationType.getSimpleName() + ":" + owner.getName() + ":" + name;
    }
}

