/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.demo.dao;

import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.FOAF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expressions;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Operand;
import org.eclipse.rdf4j.sparqlbuilder.core.Projectable;
import org.eclipse.rdf4j.sparqlbuilder.core.Variable;
import org.eclipse.rdf4j.sparqlbuilder.core.query.Queries;
import org.eclipse.rdf4j.sparqlbuilder.core.query.SelectQuery;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfObject;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicate;
import org.eclipse.rdf4j.spring.dao.RDF4JDao;
import org.eclipse.rdf4j.spring.dao.SimpleRDF4JCRUDDao;
import org.eclipse.rdf4j.spring.dao.support.bindingsBuilder.MutableBindings;
import org.eclipse.rdf4j.spring.dao.support.sparql.NamedSparqlSupplier;
import org.eclipse.rdf4j.spring.demo.model.Artist;
import org.eclipse.rdf4j.spring.demo.model.EX;
import org.eclipse.rdf4j.spring.demo.model.Painting;
import org.eclipse.rdf4j.spring.support.RDF4JTemplate;
import org.eclipse.rdf4j.spring.util.QueryResultUtils;
import org.springframework.stereotype.Component;

@Component
public class ArtistDao
extends SimpleRDF4JCRUDDao<Artist, IRI> {
    public ArtistDao(RDF4JTemplate rdf4JTemplate) {
        super(rdf4JTemplate);
    }

    protected void populateIdBindings(MutableBindings bindingsBuilder, IRI iri) {
        bindingsBuilder.add(Artist.ARTIST_ID, iri);
    }

    protected void populateBindingsForUpdate(MutableBindings bindingsBuilder, Artist artist) {
        bindingsBuilder.add(Artist.ARTIST_FIRST_NAME, artist.getFirstName()).add(Artist.ARTIST_LAST_NAME, artist.getLastName());
    }

    protected Artist mapSolution(BindingSet querySolution) {
        Artist artist = new Artist();
        artist.setId(QueryResultUtils.getIRI((BindingSet)querySolution, (Variable)Artist.ARTIST_ID));
        artist.setFirstName(QueryResultUtils.getString((BindingSet)querySolution, (Variable)Artist.ARTIST_FIRST_NAME));
        artist.setLastName(QueryResultUtils.getString((BindingSet)querySolution, (Variable)Artist.ARTIST_LAST_NAME));
        return artist;
    }

    protected String getReadQuery() {
        return "prefix foaf: <http://xmlns.com/foaf/0.1/> prefix ex: <http://example.org/> SELECT ?artist_id ?artist_firstName ?artist_lastName where {?artist_id a ex:Artist;     foaf:firstName ?artist_firstName;     foaf:surname ?artist_lastName . } ";
    }

    protected NamedSparqlSupplier getInsertSparql(Artist artist) {
        return NamedSparqlSupplier.of((String)"insert", () -> Queries.INSERT((TriplePattern[])new TriplePattern[]{Artist.ARTIST_ID.isA(new RdfObject[]{Rdf.iri((IRI)EX.Artist)}).andHas((RdfPredicate)Rdf.iri((IRI)FOAF.FIRST_NAME), new RdfObject[]{Artist.ARTIST_FIRST_NAME}).andHas((RdfPredicate)Rdf.iri((IRI)FOAF.SURNAME), new RdfObject[]{Artist.ARTIST_LAST_NAME})}).getQueryString());
    }

    protected IRI getInputId(Artist artist) {
        if (artist.getId() == null) {
            return this.getRdf4JTemplate().getNewUUID();
        }
        return artist.getId();
    }

    protected RDF4JDao.NamedSparqlSupplierPreparer prepareNamedSparqlSuppliers(RDF4JDao.NamedSparqlSupplierPreparer preparer) {
        return preparer.forKey("artists-without-paintings").supplySparql(((SelectQuery)Queries.SELECT((Projectable[])new Projectable[]{Artist.ARTIST_ID}).where(new GraphPattern[]{Artist.ARTIST_ID.isA(new RdfObject[]{Rdf.iri((IRI)EX.Artist)}).and(new GraphPattern[]{Artist.ARTIST_ID.has((RdfPredicate)Rdf.iri((IRI)EX.creatorOf), new RdfObject[]{Painting.PAINTING_ID}).optional()}).filter(Expressions.not((Operand)Expressions.bound((Variable)Painting.PAINTING_ID)))})).getQueryString());
    }

    public Set<Artist> getArtistsWithoutPaintings() {
        return this.getNamedTupleQuery("artists-without-paintings").evaluateAndConvert().toStream().map(bs -> QueryResultUtils.getIRI((BindingSet)bs, (Variable)Artist.ARTIST_ID)).map(arg_0 -> ((ArtistDao)this).getById(arg_0)).collect(Collectors.toSet());
    }

    static abstract class QUERY_KEYS {
        public static final String ARTISTS_WITHOUT_PAINTINGS = "artists-without-paintings";

        QUERY_KEYS() {
        }
    }
}

