/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spring.demo.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.spring.demo.dao.ArtistDao;
import org.eclipse.rdf4j.spring.demo.dao.PaintingDao;
import org.eclipse.rdf4j.spring.demo.model.Artist;
import org.eclipse.rdf4j.spring.demo.model.Painting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ArtService {
    @Autowired
    private ArtistDao artistDao;
    @Autowired
    private PaintingDao paintingDao;

    @Transactional
    public Artist createArtist(String firstName, String lastName) {
        Artist artist = new Artist();
        artist.setFirstName(firstName);
        artist.setLastName(lastName);
        return (Artist)this.artistDao.save(artist);
    }

    @Transactional
    public Painting createPainting(String title, String technique, IRI artist) {
        Painting painting = new Painting();
        painting.setTitle(title);
        painting.setTechnique(technique);
        painting.setArtistId(artist);
        return (Painting)this.paintingDao.save(painting);
    }

    @Transactional
    public List<Painting> getPaintings() {
        return this.paintingDao.list();
    }

    @Transactional
    public List<Artist> getArtists() {
        return this.artistDao.list();
    }

    @Transactional
    public Set<Artist> getArtistsWithoutPaintings() {
        return this.artistDao.getArtistsWithoutPaintings();
    }

    @Transactional
    public Map<Artist, Set<Painting>> getPaintingsGroupedByArtist() {
        List paintings = this.paintingDao.list();
        return paintings.stream().collect(Collectors.groupingBy(p -> (Artist)this.artistDao.getById(p.getArtistId()), Collectors.toSet()));
    }

    @Transactional
    public IRI addArtist(Artist artist) {
        return (IRI)this.artistDao.saveAndReturnId(artist);
    }

    @Transactional
    public IRI addPainting(Painting painting) {
        return (IRI)this.paintingDao.saveAndReturnId(painting);
    }
}

