/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function.spif;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.SPIF;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.BinaryFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;

public class Cast
extends BinaryFunction {
    public String getURI() {
        return SPIF.CAST_FUNCTION.toString();
    }

    protected Value evaluate(ValueFactory valueFactory, Value arg1, Value arg2) throws ValueExprEvaluationException {
        if (!(arg1 instanceof Literal)) {
            throw new ValueExprEvaluationException("First argument must be a literal");
        }
        if (!(arg2 instanceof IRI)) {
            throw new ValueExprEvaluationException("Second argument must be a datatype");
        }
        Literal value = (Literal)arg1;
        IRI targetDatatype = (IRI)arg2;
        Function func = FunctionRegistry.getInstance().get((Object)targetDatatype.stringValue()).orElse(null);
        return func != null ? func.evaluate(valueFactory, new Value[]{value}) : valueFactory.createLiteral(value.getLabel(), targetDatatype);
    }
}

