/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function.spif;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.SPIF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.BinaryFunction;

public class Mod
extends BinaryFunction {
    public String getURI() {
        return SPIF.MOD_FUNCTION.toString();
    }

    protected Value evaluate(ValueFactory valueFactory, Value arg1, Value arg2) throws ValueExprEvaluationException {
        if (!(arg1 instanceof Literal) || !(arg2 instanceof Literal)) {
            throw new ValueExprEvaluationException("Both arguments must be numeric literals");
        }
        Literal leftLit = (Literal)arg1;
        Literal rightLit = (Literal)arg2;
        IRI leftDatatype = leftLit.getDatatype();
        IRI rightDatatype = rightLit.getDatatype();
        if (!XMLDatatypeUtil.isNumericDatatype((IRI)leftDatatype)) {
            throw new ValueExprEvaluationException("Not a number: " + leftLit);
        }
        if (!XMLDatatypeUtil.isNumericDatatype((IRI)rightDatatype)) {
            throw new ValueExprEvaluationException("Not a number: " + rightLit);
        }
        IRI commonDatatype = leftDatatype.equals((Object)XMLSchema.DOUBLE) || rightDatatype.equals((Object)XMLSchema.DOUBLE) ? XMLSchema.DOUBLE : (leftDatatype.equals((Object)XMLSchema.FLOAT) || rightDatatype.equals((Object)XMLSchema.FLOAT) ? XMLSchema.FLOAT : (leftDatatype.equals((Object)XMLSchema.DECIMAL) || rightDatatype.equals((Object)XMLSchema.DECIMAL) ? XMLSchema.DECIMAL : XMLSchema.INTEGER));
        if (XMLSchema.DOUBLE.equals((Object)commonDatatype)) {
            double left = leftLit.doubleValue();
            double right = rightLit.doubleValue();
            return valueFactory.createLiteral(left % right);
        }
        if (XMLSchema.FLOAT.equals((Object)commonDatatype)) {
            float left = leftLit.floatValue();
            float right = rightLit.floatValue();
            return valueFactory.createLiteral(left % right);
        }
        if (XMLSchema.DECIMAL.equals((Object)commonDatatype)) {
            BigDecimal left = leftLit.decimalValue();
            BigDecimal right = rightLit.decimalValue();
            return valueFactory.createLiteral(left.remainder(right, MathContext.UNLIMITED));
        }
        BigInteger left = leftLit.integerValue();
        BigInteger right = rightLit.integerValue();
        return valueFactory.createLiteral(left.remainder(right));
    }
}

