/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function.spif;

import java.util.HashMap;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.SPIF;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

public class BuildString
implements Function {
    public String getURI() {
        return SPIF.BUILD_STRING_FUNCTION.toString();
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length < 1) {
            throw new ValueExprEvaluationException("Incorrect number of arguments");
        }
        if (!(args[0] instanceof Literal)) {
            throw new ValueExprEvaluationException("First argument must be a string");
        }
        Literal s = (Literal)args[0];
        String tmpl = s.getLabel();
        HashMap<String, String> mappings = new HashMap<String, String>(args.length);
        for (int i = 1; i < args.length; ++i) {
            mappings.put(Integer.toString(i), args[i].stringValue());
        }
        String newValue = StrSubstitutor.replace((Object)tmpl, mappings, (String)"{?", (String)"}");
        return valueFactory.createLiteral(newValue);
    }
}

