/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function.spif;

import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteralImpl;
import org.eclipse.rdf4j.model.vocabulary.SPIF;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.Statements;
import org.eclipse.rdf4j.spin.function.AbstractSpinFunction;

public class HasAllObjects
extends AbstractSpinFunction
implements Function {
    public HasAllObjects() {
        super(SPIF.HAS_ALL_OBJECTS_FUNCTION.stringValue());
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        QueryPreparer qp = this.getCurrentQueryPreparer();
        if (args.length != 3) {
            throw new ValueExprEvaluationException(String.format("%s requires 3 argument, got %d", this.getURI(), args.length));
        }
        Resource subj = (Resource)args[0];
        IRI pred = (IRI)args[1];
        Resource list = (Resource)args[2];
        try {
            Iteration iter = Statements.list((Resource)list, (TripleSource)qp.getTripleSource());
            while (iter.hasNext()) {
                Value obj = (Value)iter.next();
                if (Statements.single((Resource)subj, (IRI)pred, (Value)obj, (TripleSource)qp.getTripleSource()) != null) continue;
                return BooleanLiteralImpl.FALSE;
            }
        }
        catch (QueryEvaluationException e) {
            throw new ValueExprEvaluationException((Throwable)e);
        }
        return BooleanLiteralImpl.TRUE;
    }
}

