/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function;

import java.util.Set;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SP;
import org.eclipse.rdf4j.model.vocabulary.SPIN;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.Statements;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.spin.SpinParser;
import org.eclipse.rdf4j.spin.function.AbstractSpinFunction;

public class EvalFunction
extends AbstractSpinFunction
implements Function {
    private SpinParser parser;

    public EvalFunction() {
        super(SPIN.EVAL_FUNCTION.stringValue());
    }

    public EvalFunction(SpinParser parser) {
        this();
        this.parser = parser;
    }

    public SpinParser getSpinParser() {
        return this.parser;
    }

    public void setSpinParser(SpinParser parser) {
        this.parser = parser;
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        BooleanLiteral result;
        block11: {
            QueryPreparer qp = this.getCurrentQueryPreparer();
            if (args.length == 0 || !(args[0] instanceof Resource)) {
                throw new ValueExprEvaluationException("First argument must be a resource");
            }
            if (args.length % 2 == 0) {
                throw new ValueExprEvaluationException("Old number of arguments required");
            }
            Resource subj = (Resource)args[0];
            try {
                TupleQuery queryOp;
                ParsedQuery parsedQuery;
                if (this.isQuery(subj, qp.getTripleSource())) {
                    parsedQuery = this.parser.parseQuery(subj, qp.getTripleSource());
                } else {
                    ValueExpr expr = this.parser.parseExpression((Value)subj, qp.getTripleSource());
                    Extension root = new Extension((TupleExpr)new SingletonSet(), new ExtensionElem[]{new ExtensionElem(expr, "result")});
                    parsedQuery = new ParsedTupleQuery((TupleExpr)root);
                }
                if (parsedQuery instanceof ParsedTupleQuery) {
                    ParsedTupleQuery tupleQuery = (ParsedTupleQuery)parsedQuery;
                    queryOp = qp.prepare(tupleQuery);
                    EvalFunction.addArguments((Query)queryOp, args);
                    TupleQueryResult queryResult = queryOp.evaluate();
                    if (queryResult.hasNext()) {
                        BindingSet bs = (BindingSet)queryResult.next();
                        Set bindingNames = tupleQuery.getTupleExpr().getBindingNames();
                        if (!bindingNames.isEmpty()) {
                            result = bs.getValue((String)bindingNames.iterator().next());
                            break block11;
                        }
                        throw new ValueExprEvaluationException("No value");
                    }
                    throw new ValueExprEvaluationException("No value");
                }
                if (parsedQuery instanceof ParsedBooleanQuery) {
                    ParsedBooleanQuery booleanQuery = (ParsedBooleanQuery)parsedQuery;
                    queryOp = qp.prepare(booleanQuery);
                    EvalFunction.addArguments((Query)queryOp, args);
                    result = BooleanLiteral.valueOf((boolean)queryOp.evaluate());
                    break block11;
                }
                throw new ValueExprEvaluationException("First argument must be a SELECT, ASK or expression");
            }
            catch (ValueExprEvaluationException e) {
                throw e;
            }
            catch (RDF4JException e) {
                throw new ValueExprEvaluationException((Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isQuery(Resource r, TripleSource store) throws RDF4JException {
        try (CloseableIteration typeIter = Statements.getObjectURIs((Resource)r, (IRI)RDF.TYPE, (TripleSource)store);){
            while (typeIter.hasNext()) {
                URI type = (URI)typeIter.next();
                if (!SP.SELECT_CLASS.equals((Object)type) && !SP.ASK_CLASS.equals((Object)type) && !SPIN.TEMPLATES_CLASS.equals((Object)type)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    protected static void addArguments(Query query, Value ... args) throws ValueExprEvaluationException {
        for (int i = 1; i < args.length; i += 2) {
            if (!(args[i] instanceof URI)) {
                throw new ValueExprEvaluationException("Argument " + i + " must be a URI");
            }
            query.setBinding(((URI)args[i]).getLocalName(), args[i + 1]);
        }
    }
}

