/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function;

import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.spin.QueryContext;

public abstract class AbstractSpinFunction {
    private final String uri;
    private QueryPreparer queryPreparer;

    protected AbstractSpinFunction(String uri) {
        this.uri = uri;
    }

    public String getURI() {
        return this.uri;
    }

    public QueryPreparer getQueryPreparer() {
        return this.queryPreparer;
    }

    public void setQueryPreparer(QueryPreparer queryPreparer) {
        this.queryPreparer = queryPreparer;
    }

    protected QueryPreparer getCurrentQueryPreparer() {
        QueryPreparer qp;
        QueryPreparer queryPreparer = qp = this.queryPreparer != null ? this.queryPreparer : QueryContext.getQueryPreparer();
        if (qp == null) {
            throw new IllegalStateException("No QueryPreparer!");
        }
        return qp;
    }

    protected static void addBindings(Query query, Value ... args) throws ValueExprEvaluationException {
        for (int i = 1; i < args.length; i += 2) {
            if (!(args[i] instanceof Literal)) {
                throw new ValueExprEvaluationException("Argument " + i + " must be a literal");
            }
            query.setBinding(((Literal)args[i]).getLabel(), args[i + 1]);
        }
    }
}

