/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function.spif;

import java.util.List;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SPIF;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.TripleSources;
import org.eclipse.rdf4j.spin.function.AbstractSpinFunction;

public class Name
extends AbstractSpinFunction
implements Function {
    public Name() {
        super(SPIF.NAME_FUNCTION.stringValue());
    }

    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException(String.format("%s requires 1 argument, got %d", this.getURI(), args.length));
        }
        if (args[0] instanceof Literal) {
            return valueFactory.createLiteral(((Literal)args[0]).getLabel());
        }
        QueryPreparer qp = this.getCurrentQueryPreparer();
        try {
            List labels = Iterations.asList((Iteration)TripleSources.getObjectLiterals((Resource)((Resource)args[0]), (IRI)RDFS.LABEL, (TripleSource)qp.getTripleSource()));
            return !labels.isEmpty() ? (Literal)labels.get(0) : valueFactory.createLiteral(args[0].stringValue());
        }
        catch (QueryEvaluationException e) {
            throw new ValueExprEvaluationException((Throwable)e);
        }
    }
}

