/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryElement;

public abstract class QueryElementCollection<T extends QueryElement>
implements QueryElement {
    protected Collection<T> elements = new HashSet<T>();
    private String delimiter = "\n";

    protected QueryElementCollection() {
    }

    protected QueryElementCollection(String delimiter) {
        this.delimiter = delimiter;
    }

    protected QueryElementCollection(String delimiter, Collection<T> elements) {
        this.delimiter = delimiter;
        this.elements = elements;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    protected void addElements(T ... queryElements) {
        Collections.addAll(this.elements, queryElements);
    }

    protected <O> void addElements(Function<? super O, ? extends T> mapper, O ... os) {
        Arrays.stream(os).map(mapper).forEach(this.elements::add);
    }

    @Override
    public String getQueryString() {
        return this.elements.stream().map(QueryElement::getQueryString).collect(Collectors.joining(this.delimiter));
    }
}

