/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.rdf;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfBlankNode;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfLiteral;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfObject;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicate;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicateObjectList;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicateObjectListCollection;

public class Rdf {
    private static final Set<String> IRI_PROTOCOLS = Stream.of("http://", "https://", "mailto:").collect(Collectors.toSet());

    private Rdf() {
    }

    public static Iri iri(String iriString) {
        return () -> IRI_PROTOCOLS.stream().anyMatch(iriString.toLowerCase()::startsWith) ? "<" + iriString + ">" : iriString;
    }

    public static Iri iri(String namespace, String localName) {
        return Rdf.iri(namespace + localName);
    }

    public static RdfBlankNode.LabeledBlankNode bNode(String label) {
        return new RdfBlankNode.LabeledBlankNode(label);
    }

    public static RdfBlankNode.PropertiesBlankNode bNode(RdfPredicate predicate, RdfObject ... objects) {
        return new RdfBlankNode.PropertiesBlankNode(predicate, objects);
    }

    public static RdfBlankNode.AnonymousBlankNode bNode() {
        return new RdfBlankNode.AnonymousBlankNode();
    }

    public static RdfLiteral.StringLiteral literalOf(String stringValue) {
        return new RdfLiteral.StringLiteral(stringValue);
    }

    public static RdfLiteral.StringLiteral literalOfType(String stringValue, Iri dataType) {
        return new RdfLiteral.StringLiteral(stringValue, dataType);
    }

    public static RdfLiteral.StringLiteral literalOfLanguage(String stringValue, String language) {
        return new RdfLiteral.StringLiteral(stringValue, language);
    }

    public static RdfLiteral.NumericLiteral literalOf(Number numberValue) {
        return new RdfLiteral.NumericLiteral(numberValue);
    }

    public static RdfLiteral.BooleanLiteral literalOf(Boolean boolValue) {
        return new RdfLiteral.BooleanLiteral(boolValue);
    }

    public static RdfPredicateObjectList predicateObjectList(RdfPredicate predicate, RdfObject ... objects) {
        return new RdfPredicateObjectList(predicate, objects);
    }

    public static RdfPredicateObjectListCollection predicateObjectListCollection(RdfPredicate predicate, RdfObject ... objects) {
        return new RdfPredicateObjectListCollection().andHas(predicate, objects);
    }

    public static RdfPredicateObjectListCollection predicateObjectListCollection(RdfPredicateObjectList ... predicateObjectLists) {
        return new RdfPredicateObjectListCollection().andHas(predicateObjectLists);
    }

    public static RdfLiteral.StringLiteral[] toRdfLiteralArray(String ... literals) {
        return (RdfLiteral.StringLiteral[])Arrays.stream(literals).map(Rdf::literalOf).toArray(RdfLiteral.StringLiteral[]::new);
    }

    public static RdfLiteral.BooleanLiteral[] toRdfLiteralArray(Boolean ... literals) {
        return (RdfLiteral.BooleanLiteral[])Arrays.stream(literals).map(Rdf::literalOf).toArray(RdfLiteral.BooleanLiteral[]::new);
    }

    public static RdfLiteral.NumericLiteral[] toRdfLiteralArray(Number ... literals) {
        return (RdfLiteral.NumericLiteral[])Arrays.stream(literals).map(Rdf::literalOf).toArray(RdfLiteral.NumericLiteral[]::new);
    }
}

