/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.graphpattern;

import java.util.Optional;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expression;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryElementCollection;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.Filter;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphName;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.util.SparqlBuilderUtils;

class GroupGraphPattern
extends QueryElementCollection<GraphPattern>
implements GraphPattern {
    private static final String OPTIONAL = "OPTIONAL";
    private static final String GRAPH = "GRAPH ";
    private Optional<GraphName> from = Optional.empty();
    private Optional<Filter> filter = Optional.empty();
    protected boolean isOptional = false;

    GroupGraphPattern() {
        this(false);
    }

    GroupGraphPattern(boolean isOptional) {
        this.isOptional = isOptional;
    }

    GroupGraphPattern(GraphPattern original) {
        if (original instanceof GroupGraphPattern) {
            this.copy((GroupGraphPattern)original);
        } else if (original != null && !original.isEmpty()) {
            this.elements.add(original);
        }
    }

    protected void copy(GroupGraphPattern original) {
        this.elements = original.elements;
        this.isOptional = original.isOptional;
        this.from = original.from;
        this.filter = original.filter;
    }

    GroupGraphPattern and(GraphPattern ... patterns) {
        this.addElements(patterns);
        return this;
    }

    GroupGraphPattern optional(boolean isOptional) {
        this.isOptional = isOptional;
        return this;
    }

    GroupGraphPattern from(GraphName name) {
        this.from = Optional.of(name);
        return this;
    }

    GroupGraphPattern filter(Expression<?> constraint) {
        if (!this.filter.isPresent()) {
            this.filter = Optional.of(new Filter());
        }
        this.filter.get().filter(constraint);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    public boolean hasQualifier() {
        return this.isOptional || this.from.isPresent();
    }

    @Override
    public String getQueryString() {
        boolean bracketize;
        StringBuilder pattern = new StringBuilder();
        StringBuilder innerPattern = new StringBuilder();
        boolean bl = bracketize = this.elements.size() != 1 || !(this.elements.iterator().next() instanceof GroupGraphPattern);
        if (this.isOptional) {
            pattern.append(OPTIONAL).append(" ");
        }
        SparqlBuilderUtils.appendQueryElementIfPresent(this.from, pattern, GRAPH, " ");
        innerPattern.append(super.getQueryString());
        SparqlBuilderUtils.appendQueryElementIfPresent(this.filter, innerPattern, "\n", null);
        if (bracketize) {
            pattern.append(SparqlBuilderUtils.getBracedString(innerPattern.toString()));
        } else {
            pattern.append(innerPattern.toString());
        }
        return pattern.toString();
    }
}

